/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MPDbAdapter {
    private static final String LOGTAG = "MixpanelAPI";
    private static final String DATABASE_NAME = "mixpanel";
    private static final int DATABASE_VERSION = 4;
    public static final String KEY_DATA = "data";
    public static final String KEY_CREATED_AT = "created_at";
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_PEOPLE_TABLE = "CREATE TABLE " + Table.PEOPLE.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + "created_at" + ");";
    private static final String PEOPLE_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PEOPLE.getName() + " (" + "created_at" + ");";
    private final MPDatabaseHelper mDb;

    public MPDbAdapter(Context context) {
        this(context, DATABASE_NAME);
    }

    public MPDbAdapter(Context context, String dbName) {
        this.mDb = new MPDatabaseHelper(context, dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addJSON(JSONObject j, Table table) {
        String tableName = table.getName();
        Cursor c = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, j.toString());
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(tableName, null, cv);
            c = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
            c.moveToFirst();
            count = c.getInt(0);
        }
        catch (SQLiteException e) {
            Log.e((String)LOGTAG, (String)("addJSON " + tableName + " FAILED. Deleting DB."), (Throwable)e);
            if (c != null) {
                c.close();
                c = null;
            }
            this.mDb.deleteDatabase();
        }
        finally {
            if (c != null) {
                c.close();
            }
            this.mDb.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEvents(String last_id, Table table) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "_id <= " + last_id, null);
        }
        catch (SQLiteException e) {
            Log.e((String)LOGTAG, (String)("cleanupEvents " + tableName + " by id FAILED. Deleting DB."), (Throwable)e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEvents(long time, Table table) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            Log.e((String)LOGTAG, (String)("cleanupEvents " + tableName + " by time FAILED. Deleting DB."), (Throwable)e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    public void deleteDB() {
        this.mDb.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] generateDataString(Table table) {
        Cursor c = null;
        String data = null;
        String last_id = null;
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getReadableDatabase();
            c = db.rawQuery("SELECT * FROM " + tableName + " ORDER BY " + KEY_CREATED_AT + " ASC LIMIT 50", null);
            JSONArray arr = new JSONArray();
            while (c.moveToNext()) {
                if (c.isLast()) {
                    last_id = c.getString(c.getColumnIndex("_id"));
                }
                try {
                    JSONObject j = new JSONObject(c.getString(c.getColumnIndex(KEY_DATA)));
                    arr.put((Object)j);
                }
                catch (JSONException e) {}
            }
            if (arr.length() > 0) {
                data = arr.toString();
            }
        }
        catch (SQLiteException e) {
            Log.e((String)LOGTAG, (String)("generateDataString " + tableName), (Throwable)e);
            last_id = null;
            data = null;
        }
        finally {
            this.mDb.close();
            if (c != null) {
                c.close();
            }
        }
        if (last_id != null && data != null) {
            String[] ret = new String[]{last_id, data};
            return ret;
        }
        return null;
    }

    private static class MPDatabaseHelper
    extends SQLiteOpenHelper {
        private final File mDatabaseFile;

        MPDatabaseHelper(Context context, String dbName) {
            super(context, dbName, null, 4);
            this.mDatabaseFile = context.getDatabasePath(dbName);
        }

        public void deleteDatabase() {
            this.close();
            this.mDatabaseFile.delete();
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PEOPLE_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PEOPLE_TIME_INDEX);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS " + Table.EVENTS.getName());
            db.execSQL("DROP TABLE IF EXISTS " + Table.PEOPLE.getName());
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PEOPLE_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PEOPLE_TIME_INDEX);
        }
    }

    public static enum Table {
        EVENTS("events"),
        PEOPLE("people");

        private final String mTableName;

        private Table(String name) {
            this.mTableName = name;
        }

        public String getName() {
            return this.mTableName;
        }
    }
}

