/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.Survey;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

class DecideUpdates {
    private final String mToken;
    private final String mDistinctId;
    private final Set<Integer> mSurveyIds;
    private final Set<Integer> mNotificationIds;
    private final List<Survey> mUnseenSurveys;
    private final List<InAppNotification> mUnseenNotifications;
    private final OnNewResultsListener mListener;
    private final AtomicBoolean mIsDestroyed;
    private static final String LOGTAG = "MixpanelAPI DecideUpdates";

    public DecideUpdates(String token, String distinctId, OnNewResultsListener listener) {
        this.mToken = token;
        this.mDistinctId = distinctId;
        this.mListener = listener;
        this.mUnseenSurveys = new LinkedList<Survey>();
        this.mUnseenNotifications = new LinkedList<InAppNotification>();
        this.mSurveyIds = new HashSet<Integer>();
        this.mNotificationIds = new HashSet<Integer>();
        this.mIsDestroyed = new AtomicBoolean(false);
    }

    public String getToken() {
        return this.mToken;
    }

    public String getDistinctId() {
        return this.mDistinctId;
    }

    public void destroy() {
        this.mIsDestroyed.set(true);
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed.get();
    }

    public synchronized void reportResults(List<Survey> newSurveys, List<InAppNotification> newNotifications) {
        int id;
        boolean newContent = false;
        for (Survey s : newSurveys) {
            id = s.getId();
            if (this.mSurveyIds.contains(id)) continue;
            this.mSurveyIds.add(id);
            this.mUnseenSurveys.add(s);
            newContent = true;
        }
        for (InAppNotification n : newNotifications) {
            id = n.getId();
            if (this.mNotificationIds.contains(id)) continue;
            this.mNotificationIds.add(id);
            this.mUnseenNotifications.add(n);
            newContent = true;
        }
        if (newContent && this.hasUpdatesAvailable() && null != this.mListener) {
            this.mListener.onNewResults(this.getDistinctId());
        }
    }

    public synchronized Survey getSurvey(boolean replace) {
        if (this.mUnseenSurveys.isEmpty()) {
            return null;
        }
        Survey s = this.mUnseenSurveys.remove(0);
        if (replace) {
            this.mUnseenSurveys.add(this.mUnseenSurveys.size(), s);
        }
        return s;
    }

    public synchronized InAppNotification getNotification(boolean replace) {
        if (this.mUnseenNotifications.isEmpty()) {
            return null;
        }
        InAppNotification n = this.mUnseenNotifications.remove(0);
        if (replace) {
            this.mUnseenNotifications.add(this.mUnseenNotifications.size(), n);
        }
        return n;
    }

    public synchronized boolean hasUpdatesAvailable() {
        return !this.mUnseenNotifications.isEmpty() || !this.mUnseenSurveys.isEmpty();
    }

    public static interface OnNewResultsListener {
        public void onNewResults(String var1);
    }
}

