/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.BackgroundCapture;
import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.mpmetrics.DecideUpdates;
import com.mixpanel.android.mpmetrics.InAppFragment;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelActivityLifecycleCallbacks;
import com.mixpanel.android.mpmetrics.OnMixpanelUpdatesReceivedListener;
import com.mixpanel.android.mpmetrics.PersistentIdentity;
import com.mixpanel.android.mpmetrics.SharedPreferencesLoader;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyCallbacks;
import com.mixpanel.android.mpmetrics.UpdateDisplayState;
import com.mixpanel.android.surveys.SurveyActivity;
import com.mixpanel.android.util.ActivityImageUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI {
    public static final String VERSION = "4.2.2";
    private static final String LOGTAG = "MixpanelAPI";
    private static final String ENGAGE_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private final Context mContext;
    private final AnalyticsMessages mMessages;
    private final MPConfig mConfig;
    private final String mToken;
    private final PeopleImpl mPeople;
    private final PersistentIdentity mPersistentIdentity;
    private final UpdatesListener mUpdatesListener;
    private DecideUpdates mDecideUpdates;
    private static final Map<String, Map<Context, MixpanelAPI>> sInstanceMap = new HashMap<String, Map<Context, MixpanelAPI>>();
    private static final SharedPreferencesLoader sPrefsLoader = new SharedPreferencesLoader();
    private static Future<SharedPreferences> sReferrerPrefs;

    MixpanelAPI(Context context, Future<SharedPreferences> referrerPreferences, String token) {
        this.mContext = context;
        this.mToken = token;
        this.mPeople = new PeopleImpl();
        this.mMessages = this.getAnalyticsMessages();
        this.mConfig = this.getConfig();
        this.mPersistentIdentity = this.getPersistentIdentity(context, referrerPreferences, token);
        this.mUpdatesListener = new UpdatesListener();
        this.mDecideUpdates = null;
        String peopleId = this.mPersistentIdentity.getPeopleDistinctId();
        if (null != peopleId) {
            this.mDecideUpdates = this.constructDecideUpdates(token, peopleId, this.mUpdatesListener);
        }
        this.registerMixpanelActivityLifecycleCallbacks();
        if (null != this.mDecideUpdates) {
            this.mMessages.installDecideCheck(this.mDecideUpdates);
        }
        try {
            Class<?> clazz = Class.forName("android.support.v4.content.LocalBroadcastManager");
            Method methodGetInstance = clazz.getMethod("getInstance", Context.class);
            Method methodRegisterReceiver = clazz.getMethod("registerReceiver", Intent.class);
            Object localBroadcastManager = methodGetInstance.invoke(null, context);
            final MixpanelAPI instance = this;
            methodRegisterReceiver.invoke(localBroadcastManager, new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    Log.i((String)MixpanelAPI.LOGTAG, (String)"received bolts event");
                    JSONObject properties = new JSONObject();
                    Bundle args = intent.getBundleExtra("event_args");
                    if (args != null) {
                        for (String key : args.keySet()) {
                            try {
                                properties.put(key, args.get(key));
                            }
                            catch (JSONException e) {
                                Log.d((String)MixpanelAPI.LOGTAG, (String)("failed to add key \"" + key + "\" to properties for tracking bolts event"), (Throwable)e);
                            }
                        }
                    }
                    instance.track("$" + intent.getStringExtra("event_name"), properties);
                }
            }, new IntentFilter("com.parse.bolts.measurement_event"));
        }
        catch (Exception e) {
            Log.d((String)LOGTAG, (String)"App Links tracking will not be enabled due to this exception.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixpanelAPI getInstance(Context context, String token) {
        if (null == token || null == context) {
            return null;
        }
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            MixpanelAPI instance;
            Map<Context, MixpanelAPI> instances;
            Context appContext = context.getApplicationContext();
            if (null == sReferrerPrefs) {
                sReferrerPrefs = sPrefsLoader.loadPreferences(context, "com.mixpanel.android.mpmetrics.ReferralInfo", null);
            }
            if (null == (instances = sInstanceMap.get(token))) {
                instances = new HashMap<Context, MixpanelAPI>();
                sInstanceMap.put(token, instances);
            }
            if (null == (instance = instances.get(appContext))) {
                instance = new MixpanelAPI(appContext, sReferrerPrefs, token);
                instances.put(appContext, instance);
                if (context instanceof Activity) {
                    JSONObject properties = new JSONObject();
                    ClassLoader classLoader = MixpanelAPI.class.getClassLoader();
                    try {
                        Class<?> AppLinks = classLoader.loadClass("bolts.AppLinks");
                        Intent intent = ((Activity)context).getIntent();
                        Method getAppLinkData = AppLinks.getMethod("getAppLinkData", Intent.class);
                        Bundle appLinkData = (Bundle)getAppLinkData.invoke(AppLinks, intent);
                        for (String key : appLinkData.keySet()) {
                            properties.put("$AppLinkData_" + key, appLinkData.get(key));
                        }
                        Method getAppLinkExtras = AppLinks.getMethod("getAppLinkExtras", Intent.class);
                        Bundle appLinkExtras = (Bundle)getAppLinkExtras.invoke(AppLinks, intent);
                        for (String key : appLinkExtras.keySet()) {
                            properties.put("$AppLinkExtras_" + key, appLinkExtras.get(key));
                        }
                        instance.track("$al_nav_in", properties);
                    }
                    catch (Exception e) {
                        Log.d((String)LOGTAG, (String)"AppLinks tracking turned off.", (Throwable)e);
                    }
                } else {
                    Log.d((String)LOGTAG, (String)"Context is not an instance of Activity. To use AppLinks tracking, pass an instance of an Activity to getInstance. AppLinks tracking turned off.");
                }
            }
            return instance;
        }
    }

    @Deprecated
    public static void setFlushInterval(Context context, long milliseconds) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.setFlushInterval is deprecated.\n    To set a custom Mixpanel flush interval for your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.FlushInterval\" android:value=\"YOUR_INTERVAL\" />\n    to the <application> section of your AndroidManifest.xml.");
        AnalyticsMessages msgs = AnalyticsMessages.getInstance(context);
        msgs.setFlushInterval(milliseconds);
    }

    @Deprecated
    public static void enableFallbackServer(Context context, boolean enableIfTrue) {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.enableFallbackServer is deprecated.\n    To enable fallback in your application, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.DisableFallback\" android:value=\"false\" />\n    to the <application> section of your AndroidManifest.xml.");
        AnalyticsMessages msgs = AnalyticsMessages.getInstance(context);
        msgs.setDisableFallback(!enableIfTrue);
    }

    public void alias(String alias, String original) {
        if (original == null) {
            original = this.getDistinctId();
        }
        if (alias.equals(original)) {
            Log.w((String)LOGTAG, (String)("Attempted to alias identical distinct_ids " + alias + ", returning."));
            return;
        }
        try {
            JSONObject j = new JSONObject();
            j.put("alias", (Object)alias);
            j.put("original", (Object)original);
            this.track("$create_alias", j);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Failed to alias", (Throwable)e);
        }
        this.flush();
    }

    public void identify(String distinctId) {
        this.mPersistentIdentity.setEventsDistinctId(distinctId);
    }

    public void track(String eventName, JSONObject properties) {
        try {
            String key;
            JSONObject messageProps = new JSONObject();
            Map<String, String> referrerProperties = this.mPersistentIdentity.getReferrerProperties();
            for (Map.Entry<String, String> entry : referrerProperties.entrySet()) {
                key = entry.getKey();
                String value = entry.getValue();
                messageProps.put(key, (Object)value);
            }
            JSONObject superProperties = this.mPersistentIdentity.getSuperProperties();
            Iterator superIter = superProperties.keys();
            while (superIter.hasNext()) {
                key = (String)superIter.next();
                messageProps.put(key, superProperties.get(key));
            }
            long time = System.currentTimeMillis() / 1000L;
            messageProps.put("time", time);
            messageProps.put("distinct_id", (Object)this.getDistinctId());
            if (null != properties) {
                Iterator propIter = properties.keys();
                while (propIter.hasNext()) {
                    String key2 = (String)propIter.next();
                    messageProps.put(key2, properties.get(key2));
                }
            }
            AnalyticsMessages.EventDescription eventDescription = new AnalyticsMessages.EventDescription(eventName, messageProps, this.mToken);
            this.mMessages.eventsMessage(eventDescription);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Exception tracking event " + eventName), (Throwable)e);
        }
    }

    public void flush() {
        this.mMessages.postToServer();
    }

    public String getDistinctId() {
        return this.mPersistentIdentity.getEventsDistinctId();
    }

    public void registerSuperProperties(JSONObject superProperties) {
        this.mPersistentIdentity.registerSuperProperties(superProperties);
    }

    public void unregisterSuperProperty(String superPropertyName) {
        this.mPersistentIdentity.unregisterSuperProperty(superPropertyName);
    }

    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        this.mPersistentIdentity.registerSuperPropertiesOnce(superProperties);
    }

    public void clearSuperProperties() {
        this.mPersistentIdentity.clearSuperProperties();
    }

    public People getPeople() {
        return this.mPeople;
    }

    @Deprecated
    public void logPosts() {
        Log.i((String)LOGTAG, (String)"MixpanelAPI.logPosts() is deprecated.\n    To get verbose debug level logging, add\n    <meta-data android:name=\"com.mixpanel.android.MPConfig.EnableDebugLogging\" />\n    to the <application> section of your AndroidManifest.xml.");
    }

    @TargetApi(value=14)
    void registerMixpanelActivityLifecycleCallbacks() {
        if (Build.VERSION.SDK_INT >= 14 && this.mConfig.getAutoShowMixpanelUpdates()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                Application app = (Application)this.mContext.getApplicationContext();
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new MixpanelActivityLifecycleCallbacks(this));
            } else if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)"Context is NOT instanceof Application, AutoShowMixpanelUpdates will be disabled.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allInstances(InstanceProcessor processor) {
        Map<String, Map<Context, MixpanelAPI>> map = sInstanceMap;
        synchronized (map) {
            for (Map<Context, MixpanelAPI> contextInstances : sInstanceMap.values()) {
                for (MixpanelAPI instance : contextInstances.values()) {
                    processor.process(instance);
                }
            }
        }
    }

    AnalyticsMessages getAnalyticsMessages() {
        return AnalyticsMessages.getInstance(this.mContext);
    }

    MPConfig getConfig() {
        return MPConfig.getInstance(this.mContext);
    }

    PersistentIdentity getPersistentIdentity(Context context, Future<SharedPreferences> referrerPreferences, String token) {
        SharedPreferencesLoader.OnPrefsLoadedListener listener = new SharedPreferencesLoader.OnPrefsLoadedListener(){

            @Override
            public void onPrefsLoaded(SharedPreferences preferences) {
                JSONArray records = PersistentIdentity.waitingPeopleRecordsForSending(preferences);
                if (null != records) {
                    MixpanelAPI.this.sendAllPeopleRecords(records);
                }
            }
        };
        String prefsName = "com.mixpanel.android.mpmetrics.MixpanelAPI_" + token;
        Future<SharedPreferences> storedPreferences = sPrefsLoader.loadPreferences(context, prefsName, listener);
        return new PersistentIdentity(referrerPreferences, storedPreferences);
    }

    DecideUpdates constructDecideUpdates(String token, String peopleId, DecideUpdates.OnNewResultsListener listener) {
        return new DecideUpdates(token, peopleId, listener);
    }

    void clearPreferences() {
        this.mPersistentIdentity.clearPreferences();
    }

    boolean canUpdate() {
        return this.mDecideUpdates != null;
    }

    private void recordPeopleMessage(JSONObject message) {
        if (message.has("$distinct_id")) {
            this.mMessages.peopleMessage(message);
        } else {
            this.mPersistentIdentity.storeWaitingPeopleRecord(message);
        }
    }

    private void pushWaitingPeopleRecord() {
        JSONArray records = this.mPersistentIdentity.waitingPeopleRecordsForSending();
        if (null != records) {
            this.sendAllPeopleRecords(records);
        }
    }

    private void sendAllPeopleRecords(JSONArray records) {
        for (int i = 0; i < records.length(); ++i) {
            try {
                JSONObject message = records.getJSONObject(i);
                this.mMessages.peopleMessage(message);
                continue;
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Malformed people record stored pending identity, will not send it.", (Throwable)e);
            }
        }
    }

    private class UpdatesListener
    implements DecideUpdates.OnNewResultsListener,
    Runnable {
        private final Set<OnMixpanelUpdatesReceivedListener> mListeners = new HashSet<OnMixpanelUpdatesReceivedListener>();
        private final Executor mExecutor = Executors.newSingleThreadExecutor();

        private UpdatesListener() {
        }

        @Override
        public void onNewResults(String distinctId) {
            this.mExecutor.execute(this);
        }

        public synchronized void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            if (null != MixpanelAPI.this.mDecideUpdates && MixpanelAPI.this.mDecideUpdates.hasUpdatesAvailable()) {
                this.onNewResults(MixpanelAPI.this.mDecideUpdates.getDistinctId());
            }
            this.mListeners.add(listener);
        }

        public synchronized void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            this.mListeners.remove(listener);
        }

        @Override
        public synchronized void run() {
            for (OnMixpanelUpdatesReceivedListener listener : this.mListeners) {
                listener.onMixpanelUpdatesReceived();
            }
        }
    }

    private class PeopleImpl
    implements People {
        private PeopleImpl() {
        }

        @Override
        public void identify(String distinctId) {
            MixpanelAPI.this.mPersistentIdentity.setPeopleDistinctId(distinctId);
            if (null != MixpanelAPI.this.mDecideUpdates && !MixpanelAPI.this.mDecideUpdates.getDistinctId().equals(distinctId)) {
                MixpanelAPI.this.mDecideUpdates.destroy();
                MixpanelAPI.this.mDecideUpdates = null;
            }
            if (null == MixpanelAPI.this.mDecideUpdates && null != distinctId) {
                MixpanelAPI.this.mDecideUpdates = MixpanelAPI.this.constructDecideUpdates(MixpanelAPI.this.mToken, distinctId, MixpanelAPI.this.mUpdatesListener);
                MixpanelAPI.this.mMessages.installDecideCheck(MixpanelAPI.this.mDecideUpdates);
            }
            MixpanelAPI.this.pushWaitingPeopleRecord();
        }

        @Override
        public void set(JSONObject properties) {
            try {
                JSONObject sendProperties = new JSONObject();
                sendProperties.put("$android_lib_version", (Object)MixpanelAPI.VERSION);
                sendProperties.put("$android_os", (Object)"Android");
                sendProperties.put("$android_os_version", (Object)(Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE));
                try {
                    PackageManager manager = MixpanelAPI.this.mContext.getPackageManager();
                    PackageInfo info = manager.getPackageInfo(MixpanelAPI.this.mContext.getPackageName(), 0);
                    sendProperties.put("$android_app_version", (Object)info.versionName);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception getting app version name", (Throwable)e);
                }
                sendProperties.put("$android_manufacturer", (Object)(Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER));
                sendProperties.put("$android_brand", (Object)(Build.BRAND == null ? "UNKNOWN" : Build.BRAND));
                sendProperties.put("$android_model", (Object)(Build.MODEL == null ? "UNKNOWN" : Build.MODEL));
                Iterator iter = properties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    sendProperties.put(key, properties.get(key));
                }
                JSONObject message = this.stdPeopleMessage("$set", sendProperties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties", (Throwable)e);
            }
        }

        @Override
        public void set(String property, Object value) {
            try {
                this.set(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void setOnce(JSONObject properties) {
            try {
                JSONObject message = this.stdPeopleMessage("$set_once", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception setting people properties");
            }
        }

        @Override
        public void setOnce(String property, Object value) {
            try {
                this.setOnce(new JSONObject().put(property, value));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set", (Throwable)e);
            }
        }

        @Override
        public void increment(Map<String, ? extends Number> properties) {
            JSONObject json = new JSONObject(properties);
            try {
                JSONObject message = this.stdPeopleMessage("$add", json);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception incrementing properties", (Throwable)e);
            }
        }

        @Override
        public void increment(String property, double value) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put(property, value);
            this.increment(map);
        }

        @Override
        public void append(String name, Object value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, value);
                JSONObject message = this.stdPeopleMessage("$append", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception appending a property", (Throwable)e);
            }
        }

        @Override
        public void union(String name, JSONArray value) {
            try {
                JSONObject properties = new JSONObject();
                properties.put(name, (Object)value);
                JSONObject message = this.stdPeopleMessage("$union", properties);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception unioning a property");
            }
        }

        @Override
        public void unset(String name) {
            try {
                JSONArray names = new JSONArray();
                names.put((Object)name);
                JSONObject message = this.stdPeopleMessage("$unset", names);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception unsetting a property", (Throwable)e);
            }
        }

        @Override
        @Deprecated
        public void checkForSurvey(SurveyCallbacks callbacks) {
            if (null == callbacks) {
                Log.i((String)MixpanelAPI.LOGTAG, (String)"Skipping survey check because callback is null.");
                return;
            }
            Survey found = this.getSurveyIfAvailable();
            callbacks.foundSurvey(found);
        }

        @Override
        @Deprecated
        public void checkForSurvey(SurveyCallbacks callbacks, Activity parentActivity) {
            this.checkForSurvey(callbacks);
        }

        @Override
        public InAppNotification getNotificationIfAvailable() {
            if (!MixpanelAPI.this.canUpdate()) {
                return null;
            }
            return MixpanelAPI.this.mDecideUpdates.getNotification(MixpanelAPI.this.mConfig.getTestMode());
        }

        @Override
        public Survey getSurveyIfAvailable() {
            if (!MixpanelAPI.this.canUpdate()) {
                return null;
            }
            return MixpanelAPI.this.mDecideUpdates.getSurvey(MixpanelAPI.this.mConfig.getTestMode());
        }

        @Override
        @Deprecated
        public void showSurvey(Survey survey, Activity parent) {
            this.showGivenOrAvailableSurvey(survey, parent);
        }

        @Override
        public void showSurveyIfAvailable(Activity parent) {
            if (Build.VERSION.SDK_INT < 14) {
                return;
            }
            this.showGivenOrAvailableSurvey(null, parent);
        }

        @Override
        public void showSurveyById(int id2, Activity parent) {
            if (null == MixpanelAPI.this.mDecideUpdates) {
                return;
            }
            Survey s = MixpanelAPI.this.mDecideUpdates.getSurvey(id2, MixpanelAPI.this.mConfig.getTestMode());
            if (s != null) {
                this.showGivenOrAvailableSurvey(s, parent);
            }
        }

        @Override
        public void showNotificationIfAvailable(Activity parent) {
            if (Build.VERSION.SDK_INT < 14) {
                return;
            }
            this.showGivenOrAvailableNotification(null, parent);
        }

        @Override
        public void showNotificationById(int id2, Activity parent) {
            if (null == MixpanelAPI.this.mDecideUpdates) {
                return;
            }
            InAppNotification notif = MixpanelAPI.this.mDecideUpdates.getNotification(id2, MixpanelAPI.this.mConfig.getTestMode());
            if (notif != null) {
                this.showGivenOrAvailableNotification(notif, parent);
            }
        }

        @Override
        public void trackCharge(double amount, JSONObject properties) {
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                JSONObject transactionValue = new JSONObject();
                transactionValue.put("$amount", amount);
                transactionValue.put("$time", (Object)dateFormat.format(now));
                if (null != properties) {
                    Iterator iter = properties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        transactionValue.put(key, properties.get(key));
                    }
                }
                this.append("$transactions", transactionValue);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception creating new charge", (Throwable)e);
            }
        }

        @Override
        public void clearCharges() {
            this.unset("$transactions");
        }

        @Override
        public void deleteUser() {
            try {
                JSONObject message = this.stdPeopleMessage("$delete", JSONObject.NULL);
                MixpanelAPI.this.recordPeopleMessage(message);
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception deleting a user");
            }
        }

        @Override
        public void setPushRegistrationId(String registrationId) {
            if (this.getDistinctId() == null) {
                return;
            }
            MixpanelAPI.this.mPersistentIdentity.storePushId(registrationId);
            try {
                this.union("$android_devices", new JSONArray("[" + registrationId + "]"));
            }
            catch (JSONException e) {
                Log.e((String)MixpanelAPI.LOGTAG, (String)"set push registration id error", (Throwable)e);
            }
        }

        @Override
        public void clearPushRegistrationId() {
            MixpanelAPI.this.mPersistentIdentity.clearPushId();
            this.set("$android_devices", new JSONArray());
        }

        @Override
        public void initPushHandling(String senderID) {
            if (!ConfigurationChecker.checkPushConfiguration(MixpanelAPI.this.mContext)) {
                Log.i((String)MixpanelAPI.LOGTAG, (String)"Can't start push notification service. Push notifications will not work.");
                Log.i((String)MixpanelAPI.LOGTAG, (String)("See log tagged " + ConfigurationChecker.LOGTAG + " above for details."));
            } else {
                final String pushId = MixpanelAPI.this.mPersistentIdentity.getPushId();
                if (pushId == null) {
                    if (MPConfig.DEBUG) {
                        Log.d((String)MixpanelAPI.LOGTAG, (String)"Registering a new push id");
                    }
                    try {
                        Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
                        registrationIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)MixpanelAPI.this.mContext, (int)0, (Intent)new Intent(), (int)0));
                        registrationIntent.putExtra("sender", senderID);
                        MixpanelAPI.this.mContext.startService(registrationIntent);
                    }
                    catch (SecurityException e) {
                        Log.w((String)MixpanelAPI.LOGTAG, (Throwable)e);
                    }
                } else {
                    MixpanelAPI.allInstances(new InstanceProcessor(){

                        @Override
                        public void process(MixpanelAPI api) {
                            if (MPConfig.DEBUG) {
                                Log.d((String)MixpanelAPI.LOGTAG, (String)("Using existing pushId " + pushId));
                            }
                            api.getPeople().setPushRegistrationId(pushId);
                        }
                    });
                }
            }
        }

        @Override
        public String getDistinctId() {
            return MixpanelAPI.this.mPersistentIdentity.getPeopleDistinctId();
        }

        @Override
        public People withIdentity(final String distinctId) {
            if (null == distinctId) {
                return null;
            }
            return new PeopleImpl(){

                @Override
                public String getDistinctId() {
                    return distinctId;
                }

                @Override
                public void identify(String distinctId2) {
                    throw new RuntimeException("This MixpanelPeople object has a fixed, constant distinctId");
                }
            };
        }

        @Override
        public void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            MixpanelAPI.this.mUpdatesListener.addOnMixpanelUpdatesReceivedListener(listener);
        }

        @Override
        public void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener listener) {
            MixpanelAPI.this.mUpdatesListener.removeOnMixpanelUpdatesReceivedListener(listener);
        }

        public JSONObject stdPeopleMessage(String actionType, Object properties) throws JSONException {
            JSONObject dataObj = new JSONObject();
            String distinctId = this.getDistinctId();
            dataObj.put(actionType, properties);
            dataObj.put("$token", (Object)MixpanelAPI.this.mToken);
            dataObj.put("$time", System.currentTimeMillis());
            if (null != distinctId) {
                dataObj.put("$distinct_id", (Object)this.getDistinctId());
            }
            return dataObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showGivenOrAvailableSurvey(Survey surveyOrNull, final Activity parent) {
            if (Build.VERSION.SDK_INT < 14) {
                return;
            }
            if (!ConfigurationChecker.checkSurveyActivityAvailable(parent.getApplicationContext())) {
                return;
            }
            BackgroundCapture.OnBackgroundCapturedListener listener = null;
            ReentrantLock lock = UpdateDisplayState.getLockObject();
            lock.lock();
            try {
                if (UpdateDisplayState.hasCurrentProposal()) {
                    return;
                }
                Survey toShow = surveyOrNull;
                if (null == toShow) {
                    toShow = this.getSurveyIfAvailable();
                }
                if (null == toShow) {
                    return;
                }
                final UpdateDisplayState.DisplayState.SurveyState surveyDisplay = new UpdateDisplayState.DisplayState.SurveyState(toShow);
                final int intentId = UpdateDisplayState.proposeDisplay(surveyDisplay, this.getDistinctId(), MixpanelAPI.this.mToken);
                if (intentId <= 0) {
                    Log.e((String)MixpanelAPI.LOGTAG, (String)"DisplayState Lock is in an inconsistent state! Please report this issue to Mixpanel");
                    return;
                }
                listener = new BackgroundCapture.OnBackgroundCapturedListener(){

                    @Override
                    public void onBackgroundCaptured(Bitmap bitmapCaptured, int highlightColorCaptured) {
                        surveyDisplay.setBackground(bitmapCaptured);
                        surveyDisplay.setHighlightColor(highlightColorCaptured);
                        Intent surveyIntent = new Intent(parent.getApplicationContext(), SurveyActivity.class);
                        surveyIntent.addFlags(0x10000000);
                        surveyIntent.addFlags(131072);
                        surveyIntent.putExtra("com.mixpanel.android.surveys.SurveyActivity.INTENT_ID_KEY", intentId);
                        parent.startActivity(surveyIntent);
                    }
                };
            }
            finally {
                lock.unlock();
            }
            BackgroundCapture.captureBackground(parent, listener);
        }

        private void showGivenOrAvailableNotification(final InAppNotification notifOrNull, final Activity parent) {
            if (Build.VERSION.SDK_INT < 14) {
                return;
            }
            parent.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @TargetApi(value=14)
                public void run() {
                    ReentrantLock lock = UpdateDisplayState.getLockObject();
                    lock.lock();
                    try {
                        if (UpdateDisplayState.hasCurrentProposal()) {
                            return;
                        }
                        InAppNotification toShow = notifOrNull;
                        if (null == toShow) {
                            toShow = PeopleImpl.this.getNotificationIfAvailable();
                        }
                        if (null == toShow) {
                            return;
                        }
                        InAppNotification.Type inAppType = toShow.getType();
                        if (inAppType == InAppNotification.Type.TAKEOVER && !ConfigurationChecker.checkSurveyActivityAvailable(parent.getApplicationContext())) {
                            return;
                        }
                        int highlightColor = ActivityImageUtils.getHighlightColorFromBackground(parent);
                        UpdateDisplayState.DisplayState.InAppNotificationState proposal = new UpdateDisplayState.DisplayState.InAppNotificationState(toShow, highlightColor);
                        int intentId = UpdateDisplayState.proposeDisplay(proposal, PeopleImpl.this.getDistinctId(), MixpanelAPI.this.mToken);
                        if (intentId <= 0) {
                            Log.d((String)MixpanelAPI.LOGTAG, (String)"DisplayState Lock in inconsistent state! Please report this issue to Mixpanel");
                            return;
                        }
                        switch (inAppType) {
                            case MINI: {
                                UpdateDisplayState claimed = UpdateDisplayState.claimDisplayState(intentId);
                                InAppFragment inapp = new InAppFragment();
                                inapp.setDisplayState(intentId, (UpdateDisplayState.DisplayState.InAppNotificationState)claimed.getDisplayState());
                                inapp.setRetainInstance(true);
                                FragmentTransaction transaction = parent.getFragmentManager().beginTransaction();
                                transaction.setCustomAnimations(0, R.anim.com_mixpanel_android_slide_down);
                                transaction.add(0x1020002, (Fragment)inapp);
                                transaction.commit();
                                break;
                            }
                            case TAKEOVER: {
                                Intent intent = new Intent(parent.getApplicationContext(), SurveyActivity.class);
                                intent.addFlags(0x10000000);
                                intent.addFlags(131072);
                                intent.putExtra("com.mixpanel.android.surveys.SurveyActivity.INTENT_ID_KEY", intentId);
                                parent.startActivity(intent);
                                break;
                            }
                            default: {
                                Log.e((String)MixpanelAPI.LOGTAG, (String)("Unrecognized notification type " + (Object)((Object)inAppType) + " can't be shown"));
                            }
                        }
                        if (!MixpanelAPI.this.mConfig.getTestMode()) {
                            this.trackNotificationSeen(toShow);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }

                private void trackNotificationSeen(InAppNotification notif) {
                    MixpanelAPI.this.track("$campaign_delivery", notif.getCampaignProperties());
                    People people = MixpanelAPI.this.getPeople().withIdentity(PeopleImpl.this.getDistinctId());
                    SimpleDateFormat dateFormat = new SimpleDateFormat(MixpanelAPI.ENGAGE_DATE_FORMAT_STRING, Locale.US);
                    JSONObject notifProperties = notif.getCampaignProperties();
                    try {
                        notifProperties.put("$time", (Object)dateFormat.format(new Date()));
                    }
                    catch (JSONException e) {
                        Log.e((String)MixpanelAPI.LOGTAG, (String)"Exception trying to track an in app notification seen", (Throwable)e);
                    }
                    people.append("$campaigns", notif.getId());
                    people.append("$notifications", notifProperties);
                }
            });
        }
    }

    static interface InstanceProcessor {
        public void process(MixpanelAPI var1);
    }

    public static interface People {
        public void identify(String var1);

        public void set(String var1, Object var2);

        public void set(JSONObject var1);

        public void setOnce(String var1, Object var2);

        public void setOnce(JSONObject var1);

        public void increment(String var1, double var2);

        public void increment(Map<String, ? extends Number> var1);

        public void append(String var1, Object var2);

        public void union(String var1, JSONArray var2);

        public void unset(String var1);

        public void trackCharge(double var1, JSONObject var3);

        public void clearCharges();

        public void deleteUser();

        public void initPushHandling(String var1);

        public void setPushRegistrationId(String var1);

        public void clearPushRegistrationId();

        public String getDistinctId();

        public void showSurveyIfAvailable(Activity var1);

        public void showNotificationIfAvailable(Activity var1);

        public Survey getSurveyIfAvailable();

        public InAppNotification getNotificationIfAvailable();

        public void showSurveyById(int var1, Activity var2);

        public void showNotificationById(int var1, Activity var2);

        public People withIdentity(String var1);

        public void addOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener var1);

        public void removeOnMixpanelUpdatesReceivedListener(OnMixpanelUpdatesReceivedListener var1);

        @Deprecated
        public void showSurvey(Survey var1, Activity var2);

        @Deprecated
        public void checkForSurvey(SurveyCallbacks var1);

        @Deprecated
        public void checkForSurvey(SurveyCallbacks var1, Activity var2);
    }
}

