/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tweaks {
    private final Map<String, Object> mTweaks = new HashMap<String, Object>();
    private final Map<String, List<TweakChangeCallback>> mBindings = new HashMap<String, List<TweakChangeCallback>>();
    private final Handler mUiHandler = new Handler(Looper.getMainLooper());

    public String getString(String tweakName, String defaultValue) {
        try {
            return (String)this.get(tweakName, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public Integer getInteger(String tweakName, Integer defaultValue) {
        try {
            return (Integer)this.get(tweakName, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public Long getLong(String tweakName, Long defaultValue) {
        try {
            return (Long)this.get(tweakName, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public Float getFloat(String tweakName, Float defaultValue) {
        try {
            return (Float)this.get(tweakName, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public Double getDouble(String tweakName, Double defaultValue) {
        try {
            return (Double)this.get(tweakName, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public synchronized Object get(String tweakName, Object defaultValue) {
        if (!this.mTweaks.containsKey(tweakName)) {
            this.set(tweakName, defaultValue, true);
        }
        return this.mTweaks.get(tweakName);
    }

    public synchronized Map<String, Object> getAll() {
        return new HashMap<String, Object>(this.mTweaks);
    }

    public synchronized void bind(String tweakName, Object defaultValue, TweakChangeCallback callback) {
        if (!this.mBindings.containsKey(tweakName)) {
            this.mBindings.put(tweakName, new ArrayList());
        }
        this.mBindings.get(tweakName).add(callback);
        this.runCallback(callback, this.get(tweakName, defaultValue));
    }

    public void set(String tweakName, Object value) {
        this.set(tweakName, value, false);
    }

    public void set(Map<String, Object> tweakUpdates) {
        for (String tweakName : tweakUpdates.keySet()) {
            this.set(tweakName, tweakUpdates.get(tweakName));
        }
    }

    private synchronized void set(String tweakName, Object value, boolean isDefault) {
        this.mTweaks.put(tweakName, value);
        if (!isDefault && this.mBindings.containsKey(tweakName)) {
            for (TweakChangeCallback changeCallback : this.mBindings.get(tweakName)) {
                this.runCallback(changeCallback, value);
            }
        }
    }

    private void runCallback(final TweakChangeCallback callback, final Object value) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onChange(value);
            }
        });
    }

    public static interface TweakChangeCallback {
        public void onChange(Object var1);
    }
}

