/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.mixpanel.android.viewcrawler.Caller;
import com.mixpanel.android.viewcrawler.Pathfinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

@TargetApi(value=16)
abstract class ViewVisitor
implements Pathfinder.Accumulator {
    private final List<Pathfinder.PathElement> mPath;
    private final Pathfinder mPathfinder;
    private static final String LOGTAG = "MixpanelAPI.ViewVisitor";

    public void visit(View rootView) {
        this.mPathfinder.findTargetsInRoot(rootView, this.mPath, this);
    }

    public abstract void cleanup();

    protected ViewVisitor(List<Pathfinder.PathElement> path) {
        this.mPath = path;
        this.mPathfinder = new Pathfinder();
    }

    protected abstract String name();

    private static abstract class EventTriggeringVisitor
    extends ViewVisitor {
        private final OnEventListener mListener;
        private final String mEventName;
        private final boolean mDebounce;

        public EventTriggeringVisitor(List<Pathfinder.PathElement> path, String eventName, OnEventListener listener, boolean debounce) {
            super(path);
            this.mListener = listener;
            this.mEventName = eventName;
            this.mDebounce = debounce;
        }

        protected void fireEvent(View found) {
            this.mListener.OnEvent(found, this.mEventName, this.mDebounce);
        }

        protected String getEventName() {
            return this.mEventName;
        }
    }

    public static class ViewDetectorVisitor
    extends EventTriggeringVisitor {
        private boolean mSeen = false;

        public ViewDetectorVisitor(List<Pathfinder.PathElement> path, String eventName, OnEventListener listener) {
            super(path, eventName, listener, false);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void accumulate(View found) {
            if (found != null && !this.mSeen) {
                this.fireEvent(found);
            }
            this.mSeen = found != null;
        }

        @Override
        protected String name() {
            return this.getEventName() + " when Detected";
        }
    }

    public static class AddTextChangeListener
    extends EventTriggeringVisitor {
        private final Map<TextView, TextWatcher> mWatching = new HashMap<TextView, TextWatcher>();

        public AddTextChangeListener(List<Pathfinder.PathElement> path, String eventName, OnEventListener listener) {
            super(path, eventName, listener, true);
        }

        @Override
        public void cleanup() {
            for (Map.Entry<TextView, TextWatcher> entry : this.mWatching.entrySet()) {
                TextView v = entry.getKey();
                TextWatcher watcher = entry.getValue();
                v.removeTextChangedListener(watcher);
            }
            this.mWatching.clear();
        }

        @Override
        public void accumulate(View found) {
            if (found instanceof TextView) {
                TextView foundTextView = (TextView)found;
                TrackingTextWatcher watcher = new TrackingTextWatcher((View)foundTextView);
                TextWatcher oldWatcher = this.mWatching.get(foundTextView);
                if (null != oldWatcher) {
                    foundTextView.removeTextChangedListener(oldWatcher);
                }
                foundTextView.addTextChangedListener((TextWatcher)watcher);
                this.mWatching.put(foundTextView, watcher);
            }
        }

        @Override
        protected String name() {
            return this.getEventName() + " on Text Change";
        }

        private class TrackingTextWatcher
        implements TextWatcher {
            private final View mBoundTo;

            public TrackingTextWatcher(View boundTo) {
                this.mBoundTo = boundTo;
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AddTextChangeListener.this.fireEvent(this.mBoundTo);
            }
        }
    }

    public static class AddAccessibilityEventVisitor
    extends EventTriggeringVisitor {
        private final int mEventType;
        private final WeakHashMap<View, TrackingAccessibilityDelegate> mWatching;

        public AddAccessibilityEventVisitor(List<Pathfinder.PathElement> path, int accessibilityEventType, String eventName, OnEventListener listener) {
            super(path, eventName, listener, false);
            this.mEventType = accessibilityEventType;
            this.mWatching = new WeakHashMap();
        }

        @Override
        public void cleanup() {
            for (Map.Entry<View, TrackingAccessibilityDelegate> entry : this.mWatching.entrySet()) {
                View v = entry.getKey();
                TrackingAccessibilityDelegate toCleanup = entry.getValue();
                View.AccessibilityDelegate currentViewDelegate = this.getOldDelegate(v);
                if (currentViewDelegate == toCleanup) {
                    v.setAccessibilityDelegate(toCleanup.getRealDelegate());
                    continue;
                }
                if (!(currentViewDelegate instanceof TrackingAccessibilityDelegate)) continue;
                TrackingAccessibilityDelegate newChain = (TrackingAccessibilityDelegate)currentViewDelegate;
                newChain.removeFromDelegateChain(toCleanup);
            }
            this.mWatching.clear();
        }

        @Override
        public void accumulate(View found) {
            TrackingAccessibilityDelegate currentTracker;
            View.AccessibilityDelegate realDelegate = this.getOldDelegate(found);
            if (realDelegate instanceof TrackingAccessibilityDelegate && (currentTracker = (TrackingAccessibilityDelegate)realDelegate).willFireEvent(this.getEventName())) {
                return;
            }
            TrackingAccessibilityDelegate newDelegate = new TrackingAccessibilityDelegate(realDelegate);
            found.setAccessibilityDelegate((View.AccessibilityDelegate)newDelegate);
            this.mWatching.put(found, newDelegate);
        }

        @Override
        protected String name() {
            return this.getEventName() + " event when (" + this.mEventType + ")";
        }

        private View.AccessibilityDelegate getOldDelegate(View v) {
            View.AccessibilityDelegate ret = null;
            try {
                Class<?> klass = v.getClass();
                Method m = klass.getMethod("getAccessibilityDelegate", new Class[0]);
                ret = (View.AccessibilityDelegate)m.invoke((Object)v, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                Log.w((String)ViewVisitor.LOGTAG, (String)"getAccessibilityDelegate threw an exception when called.", (Throwable)e);
            }
            return ret;
        }

        private class TrackingAccessibilityDelegate
        extends View.AccessibilityDelegate {
            private View.AccessibilityDelegate mRealDelegate;

            public TrackingAccessibilityDelegate(View.AccessibilityDelegate realDelegate) {
                this.mRealDelegate = realDelegate;
            }

            public View.AccessibilityDelegate getRealDelegate() {
                return this.mRealDelegate;
            }

            public boolean willFireEvent(String eventName) {
                if (AddAccessibilityEventVisitor.this.getEventName() == eventName) {
                    return true;
                }
                if (this.mRealDelegate instanceof TrackingAccessibilityDelegate) {
                    return ((TrackingAccessibilityDelegate)this.mRealDelegate).willFireEvent(eventName);
                }
                return false;
            }

            public void removeFromDelegateChain(TrackingAccessibilityDelegate other) {
                if (this.mRealDelegate == other) {
                    this.mRealDelegate = other.getRealDelegate();
                } else if (this.mRealDelegate instanceof TrackingAccessibilityDelegate) {
                    TrackingAccessibilityDelegate child = (TrackingAccessibilityDelegate)this.mRealDelegate;
                    child.removeFromDelegateChain(other);
                }
            }

            public void sendAccessibilityEvent(View host, int eventType) {
                if (eventType == AddAccessibilityEventVisitor.this.mEventType) {
                    AddAccessibilityEventVisitor.this.fireEvent(host);
                }
                if (null != this.mRealDelegate) {
                    this.mRealDelegate.sendAccessibilityEvent(host, eventType);
                }
            }
        }
    }

    public static class PropertySetVisitor
    extends ViewVisitor {
        private final Caller mMutator;
        private final Caller mAccessor;

        public PropertySetVisitor(List<Pathfinder.PathElement> path, Caller mutator, Caller accessor) {
            super(path);
            this.mMutator = mutator;
            this.mAccessor = accessor;
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void accumulate(View found) {
            Object[] setArgs;
            if (null != this.mAccessor && 1 == (setArgs = this.mMutator.getArgs()).length) {
                Bitmap currentBitmap;
                Bitmap desiredBitmap;
                Object desiredValue = setArgs[0];
                Object currentValue = this.mAccessor.applyMethod(found);
                if (desiredValue == currentValue) {
                    return;
                }
                if (null != desiredValue && (desiredValue instanceof Bitmap && currentValue instanceof Bitmap ? (desiredBitmap = (Bitmap)desiredValue).sameAs(currentBitmap = (Bitmap)currentValue) : desiredValue.equals(currentValue))) {
                    return;
                }
            }
            this.mMutator.applyMethod(found);
        }

        @Override
        protected String name() {
            return "Property Mutator";
        }
    }

    public static interface OnEventListener {
        public void OnEvent(View var1, String var2, boolean var3);
    }
}

