/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64OutputStream;
import android.util.DisplayMetrics;
import android.util.JsonWriter;
import android.util.Log;
import android.util.LruCache;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.viewcrawler.PropertyDescription;
import com.mixpanel.android.viewcrawler.UIThreadSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;

@TargetApi(value=16)
class ViewSnapshot {
    private final RootViewFinder mRootViewFinder;
    private final List<PropertyDescription> mProperties;
    private final ClassNameCache mClassnameCache;
    private final Handler mMainThreadHandler;
    private final ResourceIds mResourceIds;
    private static final int MAX_CLASS_NAME_CACHE_SIZE = 255;
    private static final String LOGTAG = "MixpanelAPI.Snapshot";

    public ViewSnapshot(List<PropertyDescription> properties, ResourceIds resourceIds) {
        this.mProperties = properties;
        this.mResourceIds = resourceIds;
        this.mMainThreadHandler = new Handler(Looper.getMainLooper());
        this.mRootViewFinder = new RootViewFinder();
        this.mClassnameCache = new ClassNameCache(255);
    }

    public void snapshots(UIThreadSet<Activity> liveActivities, OutputStream out) throws IOException {
        block8: {
            this.mRootViewFinder.findInActivities(liveActivities);
            FutureTask<List<RootViewInfo>> infoFuture = new FutureTask<List<RootViewInfo>>(this.mRootViewFinder);
            this.mMainThreadHandler.post(infoFuture);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                List<RootViewInfo> infoList = infoFuture.get(1L, TimeUnit.SECONDS);
                int infoCount = infoList.size();
                writer.write("[");
                for (int i = 0; i < infoCount; ++i) {
                    if (i > 0) {
                        writer.write(",");
                    }
                    RootViewInfo info = infoList.get(i);
                    writer.write("{");
                    writer.write("\"activity\":");
                    writer.write(JSONObject.quote((String)info.activityName));
                    writer.write(",");
                    writer.write("\"scale\":");
                    writer.write(String.format("%s", Float.valueOf(info.scale)));
                    writer.write(",");
                    writer.write("\"serialized_objects\":");
                    JsonWriter j = new JsonWriter((Writer)writer);
                    j.beginObject();
                    j.name("rootObject").value((long)info.rootView.hashCode());
                    j.name("objects");
                    this.snapshotViewHierarchy(j, info.rootView);
                    j.endObject();
                    j.flush();
                    writer.write(",");
                    writer.write("\"screenshot\":");
                    writer.flush();
                    info.screenshot.writeBitmapJSON(Bitmap.CompressFormat.PNG, 100, out);
                    writer.write("}");
                }
                writer.write("]");
                writer.flush();
            }
            catch (InterruptedException e) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Screenshot interrupted, no screenshot will be sent.", (Throwable)e);
                }
            }
            catch (TimeoutException e) {
                if (MPConfig.DEBUG) {
                    Log.i((String)LOGTAG, (String)"Screenshot took more than 1 second to be scheduled and executed. No screenshot will be sent.", (Throwable)e);
                }
            }
            catch (ExecutionException e) {
                if (!MPConfig.DEBUG) break block8;
                Log.e((String)LOGTAG, (String)"Exception thrown during screenshot attempt", (Throwable)e);
            }
        }
    }

    List<PropertyDescription> getProperties() {
        return this.mProperties;
    }

    void snapshotViewHierarchy(JsonWriter j, View rootView) throws IOException {
        j.beginArray();
        this.snapshotView(j, rootView);
        j.endArray();
    }

    private void snapshotView(JsonWriter j, View view) throws IOException {
        ViewGroup group;
        int viewId = view.getId();
        String viewIdName = -1 == viewId ? null : this.mResourceIds.nameForId(viewId);
        j.beginObject();
        j.name("hashCode").value((long)view.hashCode());
        j.name("id").value((long)viewId);
        j.name("mp_id_name").value(viewIdName);
        CharSequence description = view.getContentDescription();
        if (null == description) {
            j.name("contentDescription").nullValue();
        } else {
            j.name("contentDescription").value(description.toString());
        }
        Object tag = view.getTag();
        if (null == tag) {
            j.name("tag").nullValue();
        } else if (tag instanceof CharSequence) {
            j.name("tag").value(tag.toString());
        }
        j.name("top").value((long)view.getTop());
        j.name("left").value((long)view.getLeft());
        j.name("width").value((long)view.getWidth());
        j.name("height").value((long)view.getHeight());
        j.name("scrollX").value((long)view.getScrollX());
        j.name("scrollY").value((long)view.getScrollY());
        j.name("visibility").value((long)view.getVisibility());
        float translationX = 0.0f;
        float translationY = 0.0f;
        if (Build.VERSION.SDK_INT >= 11) {
            translationX = view.getTranslationX();
            translationY = view.getTranslationY();
        }
        j.name("translationX").value((double)translationX);
        j.name("translationY").value((double)translationY);
        j.name("classes");
        j.beginArray();
        Class<?> klass = view.getClass();
        do {
            j.value((String)this.mClassnameCache.get(klass));
        } while ((klass = klass.getSuperclass()) != Object.class && klass != null);
        j.endArray();
        this.addProperties(j, view);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams relativeLayoutParams = (RelativeLayout.LayoutParams)layoutParams;
            int[] rules = relativeLayoutParams.getRules();
            j.name("layoutRules");
            j.beginArray();
            for (int rule : rules) {
                j.value((long)rule);
            }
            j.endArray();
        }
        j.name("subviews");
        j.beginArray();
        if (view instanceof ViewGroup) {
            group = (ViewGroup)view;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                if (null == child) continue;
                j.value((long)child.hashCode());
            }
        }
        j.endArray();
        j.endObject();
        if (view instanceof ViewGroup) {
            group = (ViewGroup)view;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                if (null == child) continue;
                this.snapshotView(j, child);
            }
        }
    }

    private void addProperties(JsonWriter j, View v) throws IOException {
        Class<?> viewClass = v.getClass();
        for (PropertyDescription desc : this.mProperties) {
            Object value;
            if (!desc.targetClass.isAssignableFrom(viewClass) || null == desc.accessor || null == (value = desc.accessor.applyMethod(v))) continue;
            if (value instanceof Number) {
                j.name(desc.name).value((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                j.name(desc.name).value(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof ColorStateList) {
                j.name(desc.name).value((Number)((ColorStateList)value).getDefaultColor());
                continue;
            }
            if (value instanceof Drawable) {
                Drawable drawable2 = (Drawable)value;
                Rect bounds = drawable2.getBounds();
                j.name(desc.name);
                j.beginObject();
                j.name("classes");
                j.beginArray();
                for (Class<?> klass = drawable2.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
                    j.value(klass.getCanonicalName());
                }
                j.endArray();
                j.name("dimensions");
                j.beginObject();
                j.name("left").value((long)bounds.left);
                j.name("right").value((long)bounds.right);
                j.name("top").value((long)bounds.top);
                j.name("bottom").value((long)bounds.bottom);
                j.endObject();
                j.endObject();
                continue;
            }
            j.name(desc.name).value(value.toString());
        }
    }

    private static class RootViewInfo {
        public final String activityName;
        public final View rootView;
        public CachedBitmap screenshot;
        public float scale;

        public RootViewInfo(String activityName, View rootView) {
            this.activityName = activityName;
            this.rootView = rootView;
            this.screenshot = null;
            this.scale = 1.0f;
        }
    }

    private static class CachedBitmap {
        private Bitmap mCached = null;
        private final Paint mPaint = new Paint(2);

        public synchronized void recreate(int width, int height, int destDensity, Bitmap source) {
            if (null == this.mCached || this.mCached.getWidth() != width || this.mCached.getHeight() != height) {
                try {
                    this.mCached = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                catch (OutOfMemoryError e) {
                    this.mCached = null;
                }
                if (null != this.mCached) {
                    this.mCached.setDensity(destDensity);
                }
            }
            if (null != this.mCached) {
                Canvas scaledCanvas = new Canvas(this.mCached);
                scaledCanvas.drawBitmap(source, 0.0f, 0.0f, this.mPaint);
            }
        }

        public synchronized void writeBitmapJSON(Bitmap.CompressFormat format, int quality, OutputStream out) throws IOException {
            if (null == this.mCached || this.mCached.getWidth() == 0 || this.mCached.getHeight() == 0) {
                out.write("null".getBytes());
            } else {
                out.write(34);
                Base64OutputStream imageOut = new Base64OutputStream(out, 2);
                this.mCached.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)imageOut);
                imageOut.flush();
                out.write(34);
            }
        }
    }

    private static class RootViewFinder
    implements Callable<List<RootViewInfo>> {
        private UIThreadSet<Activity> mLiveActivities;
        private final List<RootViewInfo> mRootViews;
        private final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
        private final CachedBitmap mCachedBitmap;
        private final int mClientDensity = 160;

        public RootViewFinder() {
            this.mRootViews = new ArrayList<RootViewInfo>();
            this.mCachedBitmap = new CachedBitmap();
        }

        public void findInActivities(UIThreadSet<Activity> liveActivities) {
            this.mLiveActivities = liveActivities;
        }

        @Override
        public List<RootViewInfo> call() throws Exception {
            this.mRootViews.clear();
            Set<Activity> liveActivities = this.mLiveActivities.getAll();
            for (Activity a : liveActivities) {
                String activityName = a.getClass().getCanonicalName();
                View rootView = a.getWindow().getDecorView().getRootView();
                a.getWindowManager().getDefaultDisplay().getMetrics(this.mDisplayMetrics);
                RootViewInfo info = new RootViewInfo(activityName, rootView);
                this.mRootViews.add(info);
            }
            int viewCount = this.mRootViews.size();
            for (int i = 0; i < viewCount; ++i) {
                RootViewInfo info = this.mRootViews.get(i);
                this.takeScreenshot(info);
            }
            return this.mRootViews;
        }

        private void takeScreenshot(RootViewInfo info) {
            Boolean originalCacheState;
            Bitmap rawBitmap;
            View rootView;
            block14: {
                rootView = info.rootView;
                rawBitmap = null;
                try {
                    Method createSnapshot = View.class.getDeclaredMethod("createSnapshot", Bitmap.Config.class, Integer.TYPE, Boolean.TYPE);
                    createSnapshot.setAccessible(true);
                    rawBitmap = (Bitmap)createSnapshot.invoke((Object)rootView, Bitmap.Config.RGB_565, -1, false);
                }
                catch (NoSuchMethodException e) {
                    if (MPConfig.DEBUG) {
                        Log.v((String)ViewSnapshot.LOGTAG, (String)"Can't call createSnapshot, will use drawCache", (Throwable)e);
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.d((String)ViewSnapshot.LOGTAG, (String)"Can't call createSnapshot with arguments", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)ViewSnapshot.LOGTAG, (String)"Exception when calling createSnapshot", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)ViewSnapshot.LOGTAG, (String)"Can't access createSnapshot, using drawCache", (Throwable)e);
                }
                catch (ClassCastException e) {
                    Log.e((String)ViewSnapshot.LOGTAG, (String)"createSnapshot didn't return a bitmap?", (Throwable)e);
                }
                originalCacheState = null;
                try {
                    if (null == rawBitmap) {
                        originalCacheState = rootView.isDrawingCacheEnabled();
                        rootView.setDrawingCacheEnabled(true);
                        rootView.buildDrawingCache(true);
                        rawBitmap = rootView.getDrawingCache();
                    }
                }
                catch (RuntimeException e) {
                    if (!MPConfig.DEBUG) break block14;
                    Log.v((String)ViewSnapshot.LOGTAG, (String)("Can't take a bitmap snapshot of view " + rootView + ", skipping for now."), (Throwable)e);
                }
            }
            float scale = 1.0f;
            if (null != rawBitmap) {
                int rawDensity = rawBitmap.getDensity();
                if (rawDensity != 0) {
                    scale = 160.0f / (float)rawDensity;
                }
                int rawWidth = rawBitmap.getWidth();
                int rawHeight = rawBitmap.getHeight();
                int destWidth = (int)((double)((float)rawBitmap.getWidth() * scale) + 0.5);
                int destHeight = (int)((double)((float)rawBitmap.getHeight() * scale) + 0.5);
                if (rawWidth > 0 && rawHeight > 0 && destWidth > 0 && destHeight > 0) {
                    this.mCachedBitmap.recreate(destWidth, destHeight, 160, rawBitmap);
                }
            }
            if (null != originalCacheState && !originalCacheState.booleanValue()) {
                rootView.setDrawingCacheEnabled(false);
            }
            info.scale = scale;
            info.screenshot = this.mCachedBitmap;
        }
    }

    private static class ClassNameCache
    extends LruCache<Class<?>, String> {
        public ClassNameCache(int maxSize) {
            super(maxSize);
        }

        protected String create(Class<?> klass) {
            return klass.getCanonicalName();
        }
    }
}

