/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Handler;
import android.support.annotation.IntDef;
import android.support.annotation.Nullable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class Tweaks {
    public static final int UNKNOWN_TYPE = 0;
    public static final int BOOLEAN_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int LONG_TYPE = 3;
    public static final int STRING_TYPE = 4;
    private final Map<String, TweakValue> mTweaks = new HashMap<String, TweakValue>();
    private final Handler mUiHandler;
    private final TweakRegistrar mRegistrar;
    private static final Map<Package, TweakRegistrar> sRegistrars = new HashMap<Package, TweakRegistrar>();
    private static final String LOGTAG = "MixpanelAPI.Tweaks";

    public static TweakRegistrar findRegistrar(String packageName) {
        TweakRegistrar ret = null;
        try {
            ClassLoader loader = TweakRegistrar.class.getClassLoader();
            Class<?> found = loader.loadClass(packageName + ".$$TWEAK_REGISTRAR");
            Field instanceField = found.getField("TWEAK_REGISTRAR");
            ret = (TweakRegistrar)instanceField.get(null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchFieldException e) {
            Log.w((String)LOGTAG, (String)"Found apparent TweakRegistrar class, but with no TWEAK_REGISTRAR member", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.w((String)LOGTAG, (String)"Found apparent TweakRegistrar class but TWEAK_REGISTRAR wasn't public and/or static", (Throwable)e);
        }
        catch (ClassCastException e) {
            Log.w((String)LOGTAG, (String)"Found apparent TweakRegistrar class, but TWEAK_REGISTRAR was not a TweakRegistrar", (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tweaks(Handler callbackHandler, @Nullable TweakRegistrar registrar) {
        this.mUiHandler = callbackHandler;
        this.mRegistrar = registrar;
        if (null != this.mRegistrar) {
            TweakRegistrar tweakRegistrar = this.mRegistrar;
            synchronized (tweakRegistrar) {
                this.mRegistrar.declareTweaks(this);
            }
        }
    }

    public String getString(String tweakName) {
        String ret = null;
        try {
            Object raw = this.get(tweakName);
            ret = (String)raw;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return ret;
    }

    public double getDouble(String tweakName) {
        double ret = 0.0;
        try {
            Object raw = this.get(tweakName);
            ret = ((Number)raw).doubleValue();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return ret;
    }

    public long getLong(String tweakName) {
        long ret = 0L;
        try {
            Object raw = this.get(tweakName);
            ret = ((Number)raw).longValue();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return ret;
    }

    public boolean getBoolean(String tweakName) {
        boolean ret = false;
        try {
            Object raw = this.get(tweakName);
            ret = (Boolean)raw;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return ret;
    }

    public synchronized Object get(String tweakName) {
        Object ret = null;
        TweakValue value = this.mTweaks.get(tweakName);
        if (null != value) {
            ret = value.getValue();
        }
        return ret;
    }

    public synchronized Map<String, TweakDescription> getDescriptions() {
        HashMap<String, TweakDescription> ret = new HashMap<String, TweakDescription>();
        for (Map.Entry<String, TweakValue> entry : this.mTweaks.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().description);
        }
        return ret;
    }

    public synchronized void defineTweak(String tweakName, Object defaultValue) {
        if (this.mTweaks.containsKey(tweakName)) {
            Log.w((String)LOGTAG, (String)("Attempt to define a tweak \"" + tweakName + "\" twice with the same name"));
            return;
        }
        int tweakType = this.determineType(defaultValue);
        TweakDescription description = new TweakDescription(tweakType, defaultValue, null, null);
        TweakValue value = new TweakValue(description);
        this.mTweaks.put(tweakName, value);
    }

    public synchronized void bind(String tweakName, Object scope, TweakChangeCallback callback) {
        if (null == scope) {
            scope = this;
        }
        if (!this.mTweaks.containsKey(tweakName)) {
            Log.w((String)LOGTAG, (String)("Attempt to bind to a tweak \"" + tweakName + "\" which doesn't exist"));
            return;
        }
        TweakValue value = this.mTweaks.get(tweakName);
        value.bindings.put(scope, callback);
        this.runCallback(callback, this.get(tweakName));
    }

    public synchronized void set(String tweakName, Object value) {
        if (!this.mTweaks.containsKey(tweakName)) {
            Log.w((String)LOGTAG, (String)("Attempt to set a tweak \"" + tweakName + "\" which has never been defined."));
            return;
        }
        TweakValue container = this.mTweaks.get(tweakName);
        container.setValue(value);
        Collection<TweakChangeCallback> callbackLists = container.bindings.values();
        for (TweakChangeCallback callback : callbackLists) {
            this.runCallback(callback, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForTweaks(Object registrant) {
        if (null != this.mRegistrar) {
            TweakRegistrar tweakRegistrar = this.mRegistrar;
            synchronized (tweakRegistrar) {
                this.mRegistrar.registerObjectForTweaks(this, registrant);
            }
        }
    }

    private void runCallback(final TweakChangeCallback callback, final Object value) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onChange(value);
            }
        });
    }

    private int determineType(Object thing) {
        if (thing instanceof String) {
            return 4;
        }
        if (thing instanceof Double || thing instanceof Float) {
            return 2;
        }
        if (thing instanceof Long || thing instanceof Integer || thing instanceof Short || thing instanceof Byte) {
            return 3;
        }
        if (thing instanceof Boolean) {
            return 1;
        }
        return 0;
    }

    private static class TweakValue {
        public final WeakHashMap<Object, TweakChangeCallback> bindings;
        public final TweakDescription description;
        private Object mValue;

        public TweakValue(TweakDescription aDescription) {
            this.description = aDescription;
            this.bindings = new WeakHashMap();
            this.mValue = aDescription.defaultValue;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object value) {
            this.mValue = value;
        }
    }

    public static class TweakDescription {
        public final int type;
        public final Number minimum;
        public final Number maximum;
        public final Object defaultValue;

        public TweakDescription(int aType, Object aDefaultValue, Number aMin, Number aMax) {
            this.type = aType;
            this.defaultValue = aDefaultValue;
            this.minimum = aMin;
            this.maximum = aMax;
        }
    }

    public static interface TweakRegistrar {
        public void declareTweaks(Tweaks var1);

        public void registerObjectForTweaks(Tweaks var1, Object var2);
    }

    public static interface TweakChangeCallback {
        public void onChange(Object var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L})
    public static @interface TweakType {
    }
}

