/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.util.Log;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

class DecideMessages {
    private String mDistinctId;
    private final String mToken;
    private final Set<Integer> mSurveyIds;
    private final Set<Integer> mNotificationIds;
    private final List<Survey> mUnseenSurveys;
    private final List<InAppNotification> mUnseenNotifications;
    private final OnNewResultsListener mListener;
    private final UpdatesFromMixpanel mUpdatesFromMixpanel;
    private JSONArray mVariants;
    private static final String LOGTAG = "MixpanelAPI.DecideUpdts";

    public DecideMessages(String token, OnNewResultsListener listener, UpdatesFromMixpanel updatesFromMixpanel) {
        this.mToken = token;
        this.mListener = listener;
        this.mUpdatesFromMixpanel = updatesFromMixpanel;
        this.mDistinctId = null;
        this.mUnseenSurveys = new LinkedList<Survey>();
        this.mUnseenNotifications = new LinkedList<InAppNotification>();
        this.mSurveyIds = new HashSet<Integer>();
        this.mNotificationIds = new HashSet<Integer>();
    }

    public String getToken() {
        return this.mToken;
    }

    public synchronized void setDistinctId(String distinctId) {
        this.mUnseenSurveys.clear();
        this.mUnseenNotifications.clear();
        this.mDistinctId = distinctId;
    }

    public synchronized String getDistinctId() {
        return this.mDistinctId;
    }

    public synchronized void reportResults(List<Survey> newSurveys, List<InAppNotification> newNotifications, JSONArray eventBindings, JSONArray variants) {
        int id;
        boolean newContent = false;
        this.mUpdatesFromMixpanel.setEventBindings(eventBindings);
        for (Survey s : newSurveys) {
            id = s.getId();
            if (this.mSurveyIds.contains(id)) continue;
            this.mSurveyIds.add(id);
            this.mUnseenSurveys.add(s);
            newContent = true;
        }
        for (InAppNotification n : newNotifications) {
            id = n.getId();
            if (this.mNotificationIds.contains(id)) continue;
            this.mNotificationIds.add(id);
            this.mUnseenNotifications.add(n);
            newContent = true;
        }
        this.mVariants = variants;
        if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)("New Decide content has become available. " + newSurveys.size() + " surveys and " + newNotifications.size() + " notifications have been added."));
        }
        if (newContent && this.hasUpdatesAvailable() && null != this.mListener) {
            this.mListener.onNewResults();
        }
    }

    public synchronized Survey getSurvey(boolean replace) {
        if (this.mUnseenSurveys.isEmpty()) {
            return null;
        }
        Survey s = this.mUnseenSurveys.remove(0);
        if (replace) {
            this.mUnseenSurveys.add(this.mUnseenSurveys.size(), s);
        }
        return s;
    }

    public synchronized Survey getSurvey(int id, boolean replace) {
        Survey survey = null;
        for (int i = 0; i < this.mUnseenSurveys.size(); ++i) {
            if (this.mUnseenSurveys.get(i).getId() != id) continue;
            survey = this.mUnseenSurveys.get(i);
            if (replace) break;
            this.mUnseenSurveys.remove(i);
            break;
        }
        return survey;
    }

    public synchronized JSONArray getVariants() {
        return this.mVariants;
    }

    public synchronized InAppNotification getNotification(boolean replace) {
        if (this.mUnseenNotifications.isEmpty()) {
            if (MPConfig.DEBUG) {
                Log.v((String)LOGTAG, (String)"No unseen notifications exist, none will be returned.");
            }
            return null;
        }
        InAppNotification n = this.mUnseenNotifications.remove(0);
        if (replace) {
            this.mUnseenNotifications.add(this.mUnseenNotifications.size(), n);
        } else if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)("Recording notification " + n + " as seen."));
        }
        return n;
    }

    public synchronized InAppNotification getNotification(int id, boolean replace) {
        InAppNotification notif = null;
        for (int i = 0; i < this.mUnseenNotifications.size(); ++i) {
            if (this.mUnseenNotifications.get(i).getId() != id) continue;
            notif = this.mUnseenNotifications.get(i);
            if (replace) break;
            this.mUnseenNotifications.remove(i);
            break;
        }
        return notif;
    }

    public synchronized boolean hasUpdatesAvailable() {
        return !this.mUnseenNotifications.isEmpty() || !this.mUnseenSurveys.isEmpty() || this.mVariants != null;
    }

    public static interface OnNewResultsListener {
        public void onNewResults();
    }
}

