/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.InAppButton;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.TakeoverInAppNotification;
import com.mixpanel.android.mpmetrics.UpdateDisplayState;
import com.mixpanel.android.surveys.CardCarouselLayout;
import com.mixpanel.android.surveys.FadingImageView;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.ViewUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@TargetApi(value=16)
@SuppressLint(value={"ClickableViewAccessibility"})
public class SurveyActivity
extends Activity {
    private AlertDialog mDialog;
    private CardCarouselLayout mCardHolder;
    private MixpanelAPI mMixpanel;
    private View mPreviousButton;
    private View mNextButton;
    private TextView mProgressTextView;
    private UpdateDisplayState mUpdateDisplayState;
    private boolean mSurveyBegun = false;
    private int mCurrentQuestion = 0;
    private int mIntentId = -1;
    private static final String SURVEY_BEGUN_BUNDLE_KEY = "com.mixpanel.android.surveys.SurveyActivity.SURVEY_BEGIN_BUNDLE_KEY";
    private static final String CURRENT_QUESTION_BUNDLE_KEY = "com.mixpanel.android.surveys.SurveyActivity.CURRENT_QUESTION_BUNDLE_KEY";
    private static final String SURVEY_STATE_BUNDLE_KEY = "com.mixpanel.android.surveys.SurveyActivity.SURVEY_STATE_BUNDLE_KEY";
    private static final int GRAY_30PERCENT = Color.argb((int)255, (int)90, (int)90, (int)90);
    private static final int SHADOW_SIZE_THRESHOLD_PX = 100;
    private static final String LOGTAG = "MixpanelAPI.SrvyActvty";
    public static final String INTENT_ID_KEY = "com.mixpanel.android.surveys.SurveyActivity.INTENT_ID_KEY";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mIntentId = this.getIntent().getIntExtra(INTENT_ID_KEY, Integer.MAX_VALUE);
        this.mUpdateDisplayState = UpdateDisplayState.claimDisplayState(this.mIntentId);
        if (null == this.mUpdateDisplayState) {
            MPLog.e(LOGTAG, "SurveyActivity intent received, but nothing was found to show.");
            this.finish();
            return;
        }
        this.mMixpanel = MixpanelAPI.getInstance((Context)this, this.mUpdateDisplayState.getToken());
        if (this.isShowingInApp()) {
            this.onCreateInAppNotification();
        } else if (this.isShowingSurvey()) {
            this.onCreateSurvey(savedInstanceState);
        } else {
            this.finish();
        }
    }

    private void onCreateInAppNotification() {
        this.setContentView(R.layout.com_mixpanel_android_activity_notification_full);
        ImageView backgroundImage = (ImageView)this.findViewById(R.id.com_mixpanel_android_notification_gradient);
        FadingImageView inAppImageView = (FadingImageView)this.findViewById(R.id.com_mixpanel_android_notification_image);
        TextView titleView = (TextView)this.findViewById(R.id.com_mixpanel_android_notification_title);
        TextView subtextView = (TextView)this.findViewById(R.id.com_mixpanel_android_notification_subtext);
        ArrayList<Button> ctaButtons = new ArrayList<Button>();
        Button ctaButton = (Button)this.findViewById(R.id.com_mixpanel_android_notification_button);
        ctaButtons.add(ctaButton);
        Button secondCtaButton = (Button)this.findViewById(R.id.com_mixpanel_android_notification_second_button);
        ctaButtons.add(secondCtaButton);
        LinearLayout closeButtonWrapper = (LinearLayout)this.findViewById(R.id.com_mixpanel_android_button_exit_wrapper);
        ImageView closeButtonImageView = (ImageView)this.findViewById(R.id.com_mixpanel_android_image_close);
        UpdateDisplayState.DisplayState.InAppNotificationState notificationState = (UpdateDisplayState.DisplayState.InAppNotificationState)this.mUpdateDisplayState.getDisplayState();
        TakeoverInAppNotification inApp = (TakeoverInAppNotification)notificationState.getInAppNotification();
        Display display = this.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        if (this.getResources().getConfiguration().orientation == 1) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)closeButtonWrapper.getLayoutParams();
            params.setMargins(0, 0, 0, (int)((float)size.y * 0.06f));
            closeButtonWrapper.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        inAppImageView.showShadow(inApp.setShouldShowShadow());
        backgroundImage.setBackgroundColor(inApp.getBackgroundColor());
        if (inApp.hasTitle()) {
            titleView.setVisibility(0);
            titleView.setText((CharSequence)inApp.getTitle());
            titleView.setTextColor(inApp.getTitleColor());
        } else {
            titleView.setVisibility(8);
        }
        if (inApp.hasBody()) {
            subtextView.setVisibility(0);
            subtextView.setText((CharSequence)inApp.getBody());
            subtextView.setTextColor(inApp.getBodyColor());
        } else {
            subtextView.setVisibility(8);
        }
        inAppImageView.setImageBitmap(inApp.getImage());
        for (int i = 0; i < ctaButtons.size(); ++i) {
            InAppButton inAppButtonModel = inApp.getButton(i);
            Button inAppButton = (Button)ctaButtons.get(i);
            this.setUpInAppButton(inAppButton, inAppButtonModel, inApp);
        }
        if (inApp.getNumButtons() == 1) {
            LinearLayout.LayoutParams oneButtonLayoutParams = (LinearLayout.LayoutParams)ctaButton.getLayoutParams();
            oneButtonLayoutParams.weight = 0.0f;
            oneButtonLayoutParams.width = -2;
            ctaButton.setLayoutParams((ViewGroup.LayoutParams)oneButtonLayoutParams);
        }
        closeButtonImageView.setColorFilter(inApp.getCloseColor());
        closeButtonWrapper.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SurveyActivity.this.finish();
                UpdateDisplayState.releaseDisplayState(SurveyActivity.this.mIntentId);
            }
        });
        this.setUpNotificationAnimations(inAppImageView, titleView, subtextView, ctaButtons, closeButtonWrapper);
    }

    private void setUpInAppButton(Button inAppButton, final InAppButton inAppButtonModel, final InAppNotification inApp) {
        if (inAppButtonModel != null) {
            inAppButton.setVisibility(0);
            inAppButton.setText((CharSequence)inAppButtonModel.getText());
            inAppButton.setTextColor(inAppButtonModel.getTextColor());
            inAppButton.setTransformationMethod(null);
            GradientDrawable buttonBackground = new GradientDrawable();
            int[][] states = new int[][]{{16842919}, {16842910}};
            int highlightColor = 0x33868686;
            if (inAppButtonModel.getBackgroundColor() != 0) {
                highlightColor = ViewUtils.mixColors(inAppButtonModel.getBackgroundColor(), highlightColor);
            }
            int[] colors = new int[]{highlightColor, inAppButtonModel.getBackgroundColor()};
            buttonBackground.setColor(new ColorStateList((int[][])states, colors));
            buttonBackground.setStroke((int)ViewUtils.dpToPx(2.0f, (Context)this), inAppButtonModel.getBorderColor());
            buttonBackground.setCornerRadius((float)((int)ViewUtils.dpToPx(5.0f, (Context)this)));
            if (Build.VERSION.SDK_INT < 16) {
                inAppButton.setBackgroundDrawable((Drawable)buttonBackground);
            } else {
                inAppButton.setBackground((Drawable)buttonBackground);
            }
            inAppButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String uriString = inAppButtonModel.getCtaUrl();
                    if (uriString != null && uriString.length() > 0) {
                        Uri uri;
                        try {
                            uri = Uri.parse((String)uriString);
                        }
                        catch (IllegalArgumentException e) {
                            MPLog.i(SurveyActivity.LOGTAG, "Can't parse notification URI, will not take any action", e);
                            return;
                        }
                        try {
                            Intent viewIntent = new Intent("android.intent.action.VIEW", uri);
                            SurveyActivity.this.startActivity(viewIntent);
                            SurveyActivity.this.mMixpanel.getPeople().trackNotification("$campaign_open", inApp);
                        }
                        catch (ActivityNotFoundException e) {
                            MPLog.i(SurveyActivity.LOGTAG, "User doesn't have an activity for notification URI");
                        }
                    }
                    SurveyActivity.this.finish();
                    UpdateDisplayState.releaseDisplayState(SurveyActivity.this.mIntentId);
                }
            });
        } else {
            inAppButton.setVisibility(8);
        }
    }

    private void setUpNotificationAnimations(ImageView notificationImage, TextView notificationTitle, TextView notificationBody, ArrayList<Button> ctaButtons, LinearLayout closeButtonWrapper) {
        ScaleAnimation scale = new ScaleAnimation(0.95f, 1.0f, 0.95f, 1.0f, 1, 0.5f, 1, 1.0f);
        scale.setDuration(200L);
        notificationImage.startAnimation((Animation)scale);
        TranslateAnimation translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.5f, 1, 0.0f);
        translate.setInterpolator((Interpolator)new DecelerateInterpolator());
        translate.setDuration(200L);
        notificationTitle.startAnimation((Animation)translate);
        notificationBody.startAnimation((Animation)translate);
        for (Button ctaButton : ctaButtons) {
            ctaButton.startAnimation((Animation)translate);
        }
        Animation fadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.com_mixpanel_android_fade_in);
        closeButtonWrapper.startAnimation(fadeIn);
    }

    private void onCreateSurvey(Bundle savedInstanceState) {
        String answerDistinctId;
        this.requestOrientationLock();
        if (null != savedInstanceState) {
            this.mCurrentQuestion = savedInstanceState.getInt(CURRENT_QUESTION_BUNDLE_KEY, 0);
            this.mSurveyBegun = savedInstanceState.getBoolean(SURVEY_BEGUN_BUNDLE_KEY);
        }
        if (null == (answerDistinctId = this.mUpdateDisplayState.getDistinctId())) {
            MPLog.i(LOGTAG, "Can't show a survey to a user with no distinct id set");
            this.finish();
            return;
        }
        this.setContentView(R.layout.com_mixpanel_android_activity_survey);
        UpdateDisplayState.DisplayState.SurveyState surveyState = this.getSurveyState();
        Bitmap background = surveyState.getBackground();
        if (null == background) {
            View contentView = this.findViewById(R.id.com_mixpanel_android_activity_survey_id);
            contentView.setBackgroundColor(GRAY_30PERCENT);
        } else {
            this.getWindow().setBackgroundDrawable((Drawable)new BitmapDrawable(this.getResources(), background));
        }
        this.mPreviousButton = this.findViewById(R.id.com_mixpanel_android_button_previous);
        this.mNextButton = this.findViewById(R.id.com_mixpanel_android_button_next);
        this.mProgressTextView = (TextView)this.findViewById(R.id.com_mixpanel_android_progress_text);
        this.mCardHolder = (CardCarouselLayout)this.findViewById(R.id.com_mixpanel_android_question_card_holder);
        this.mCardHolder.setOnQuestionAnsweredListener(new CardCarouselLayout.OnQuestionAnsweredListener(){

            @Override
            public void onQuestionAnswered(Survey.Question question, String answer) {
                SurveyActivity.this.saveAnswer(question, answer);
                SurveyActivity.this.goToNextQuestion();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        UpdateDisplayState.DisplayState displayState = this.mUpdateDisplayState.getDisplayState();
        if (null != displayState && displayState.getType() == "SurveyState") {
            this.onStartSurvey();
        }
    }

    private void onStartSurvey() {
        if (this.mSurveyBegun) {
            return;
        }
        if (!MPConfig.getInstance((Context)this).getTestMode()) {
            this.trackSurveyAttempted();
        }
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this);
        alertBuilder.setTitle(R.string.com_mixpanel_android_survey_prompt_dialog_title);
        alertBuilder.setMessage(R.string.com_mixpanel_android_survey_prompt_dialog_message);
        alertBuilder.setPositiveButton(R.string.com_mixpanel_android_sure, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SurveyActivity.this.findViewById(R.id.com_mixpanel_android_activity_survey_id).setVisibility(0);
                SurveyActivity.this.mSurveyBegun = true;
                SurveyActivity.this.showQuestion(SurveyActivity.this.mCurrentQuestion);
            }
        });
        alertBuilder.setNegativeButton(R.string.com_mixpanel_android_no_thanks, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SurveyActivity.this.finish();
            }
        });
        alertBuilder.setCancelable(false);
        this.mDialog = alertBuilder.create();
        this.mDialog.show();
    }

    protected void onPause() {
        super.onPause();
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
    }

    protected void onDestroy() {
        if (this.isShowingSurvey()) {
            this.onDestroySurvey();
        }
        super.onDestroy();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void onDestroySurvey() {
        if (null != this.mMixpanel) {
            if (this.mUpdateDisplayState != null && this.mUpdateDisplayState.getDistinctId() != null) {
                UpdateDisplayState.DisplayState.SurveyState surveyState = this.getSurveyState();
                Survey survey = surveyState.getSurvey();
                List<Survey.Question> questionList = survey.getQuestions();
                int answerCount = 0;
                String answerDistinctId = this.mUpdateDisplayState.getDistinctId();
                MixpanelAPI.People people = this.mMixpanel.getPeople().withIdentity(answerDistinctId);
                people.append("$responses", survey.getCollectionId());
                UpdateDisplayState.AnswerMap answers = surveyState.getAnswers();
                for (Survey.Question question : questionList) {
                    String answerString = answers.get(question.getId());
                    if (null == answerString) continue;
                    try {
                        JSONObject answerJson = new JSONObject();
                        answerJson.put("$survey_id", survey.getId());
                        answerJson.put("$collection_id", survey.getCollectionId());
                        answerJson.put("$question_id", question.getId());
                        answerJson.put("$question_type", (Object)question.getType().toString());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        answerJson.put("$time", (Object)dateFormat.format(new Date()));
                        answerJson.put("$value", (Object)answerString);
                        people.append("$answers", answerJson);
                        ++answerCount;
                    }
                    catch (JSONException e) {
                        MPLog.e(LOGTAG, "Couldn't record user's answer.", e);
                    }
                }
                try {
                    JSONObject surveyJson = new JSONObject();
                    surveyJson.put("survey_id", survey.getId());
                    surveyJson.put("collection_id", survey.getCollectionId());
                    surveyJson.put("$answer_count", answerCount);
                    surveyJson.put("$survey_shown", this.mSurveyBegun);
                    this.mMixpanel.track("$show_survey", surveyJson);
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Couldn't record survey shown.", e);
                }
            }
            this.mMixpanel.flush();
        }
        UpdateDisplayState.releaseDisplayState(this.mIntentId);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.isShowingSurvey()) {
            this.onSaveInstanceStateSurvey(outState);
        }
    }

    private void onSaveInstanceStateSurvey(Bundle outState) {
        outState.putBoolean(SURVEY_BEGUN_BUNDLE_KEY, this.mSurveyBegun);
        outState.putInt(CURRENT_QUESTION_BUNDLE_KEY, this.mCurrentQuestion);
        outState.putParcelable(SURVEY_STATE_BUNDLE_KEY, (Parcelable)this.mUpdateDisplayState);
    }

    public void onBackPressed() {
        if (this.isShowingSurvey() && this.mCurrentQuestion > 0) {
            this.goToPreviousQuestion();
        } else {
            if (this.isShowingInApp()) {
                UpdateDisplayState.releaseDisplayState(this.mIntentId);
            }
            super.onBackPressed();
        }
    }

    public void goToPreviousQuestion(View v) {
        this.goToPreviousQuestion();
    }

    public void goToNextQuestion(View v) {
        this.goToNextQuestion();
    }

    public void completeSurvey(View v) {
        this.completeSurvey();
    }

    private UpdateDisplayState.DisplayState.SurveyState getSurveyState() {
        return (UpdateDisplayState.DisplayState.SurveyState)this.mUpdateDisplayState.getDisplayState();
    }

    private boolean isShowingSurvey() {
        if (null == this.mUpdateDisplayState) {
            return false;
        }
        return "SurveyState".equals(this.mUpdateDisplayState.getDisplayState().getType());
    }

    private boolean isShowingInApp() {
        if (null == this.mUpdateDisplayState) {
            return false;
        }
        return "InAppNotificationState".equals(this.mUpdateDisplayState.getDisplayState().getType());
    }

    private void trackSurveyAttempted() {
        UpdateDisplayState.DisplayState.SurveyState surveyState = this.getSurveyState();
        Survey survey = surveyState.getSurvey();
        MixpanelAPI.People people = this.mMixpanel.getPeople().withIdentity(this.mUpdateDisplayState.getDistinctId());
        people.append("$surveys", survey.getId());
        people.append("$collections", survey.getCollectionId());
    }

    private void goToPreviousQuestion() {
        if (this.mCurrentQuestion > 0) {
            this.showQuestion(this.mCurrentQuestion - 1);
        } else {
            this.completeSurvey();
        }
    }

    private void goToNextQuestion() {
        UpdateDisplayState.DisplayState.SurveyState surveyState = this.getSurveyState();
        int surveySize = surveyState.getSurvey().getQuestions().size();
        if (this.mCurrentQuestion < surveySize - 1) {
            this.showQuestion(this.mCurrentQuestion + 1);
        } else {
            this.completeSurvey();
        }
    }

    private void showQuestion(int idx) {
        UpdateDisplayState.DisplayState.SurveyState surveyState = this.getSurveyState();
        List<Survey.Question> questions = surveyState.getSurvey().getQuestions();
        if (0 == idx || questions.size() == 0) {
            this.mPreviousButton.setVisibility(8);
        } else {
            this.mPreviousButton.setVisibility(0);
        }
        if (idx >= questions.size() - 1) {
            this.mNextButton.setVisibility(8);
        } else {
            this.mNextButton.setVisibility(0);
        }
        int oldQuestion = this.mCurrentQuestion;
        this.mCurrentQuestion = idx;
        Survey.Question question = questions.get(idx);
        UpdateDisplayState.AnswerMap answers = surveyState.getAnswers();
        String answerValue = answers.get(question.getId());
        try {
            if (oldQuestion < idx) {
                this.mCardHolder.moveTo(question, answerValue, CardCarouselLayout.Direction.FORWARD);
            } else if (oldQuestion > idx) {
                this.mCardHolder.moveTo(question, answerValue, CardCarouselLayout.Direction.BACKWARD);
            } else {
                this.mCardHolder.replaceTo(question, answerValue);
            }
        }
        catch (CardCarouselLayout.UnrecognizedAnswerTypeException e) {
            this.goToNextQuestion();
            return;
        }
        if (questions.size() > 1) {
            this.mProgressTextView.setText((CharSequence)("" + (idx + 1) + " of " + questions.size()));
        } else {
            this.mProgressTextView.setText((CharSequence)"");
        }
    }

    private void saveAnswer(Survey.Question question, String answer) {
        UpdateDisplayState.DisplayState.SurveyState surveyState = this.getSurveyState();
        UpdateDisplayState.AnswerMap answers = surveyState.getAnswers();
        answers.put(question.getId(), answer.toString());
    }

    @SuppressLint(value={"NewApi"})
    private void requestOrientationLock() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.setRequestedOrientation(14);
        } else {
            int currentOrientation = this.getResources().getConfiguration().orientation;
            if (currentOrientation == 2) {
                this.setRequestedOrientation(0);
            } else if (currentOrientation == 1) {
                this.setRequestedOrientation(1);
            }
        }
    }

    private void completeSurvey() {
        this.finish();
    }
}

