/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.OfflineMode;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class MPConfig {
    public static final String VERSION = "5.0.0";
    public static boolean DEBUG = false;
    public static final int UI_FEATURES_MIN_API = 16;
    static final String REFERRER_PREFS_NAME = "com.mixpanel.android.mpmetrics.ReferralInfo";
    static final int MAX_NOTIFICATION_CACHE_COUNT = 2;
    private final int mBulkUploadLimit;
    private final int mFlushInterval;
    private final int mDataExpiration;
    private final int mMinimumDatabaseLimit;
    private final boolean mDisableFallback;
    private final boolean mTestMode;
    private final boolean mDisableGestureBindingUI;
    private final boolean mDisableEmulatorBindingUI;
    private final boolean mDisableAppOpenEvent;
    private final boolean mDisableViewCrawler;
    private final String[] mDisableViewCrawlerForProjects;
    private final String mEventsEndpoint;
    private final String mEventsFallbackEndpoint;
    private final String mPeopleEndpoint;
    private final String mPeopleFallbackEndpoint;
    private final String mDecideEndpoint;
    private final String mDecideFallbackEndpoint;
    private final boolean mAutoShowMixpanelUpdates;
    private final String mEditorUrl;
    private final String mResourcePackageName;
    private final boolean mDisableDecideChecker;
    private final int mImageCacheMaxMemoryFactor;
    private final boolean mIgnoreInvisibleViewsEditor;
    private SSLSocketFactory mSSLSocketFactory;
    private OfflineMode mOfflineMode;
    private static MPConfig sInstance;
    private static final Object sInstanceLock;
    private static final String LOGTAG = "MixpanelAPI.Conf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPConfig getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (null == sInstance) {
                Context appContext = context.getApplicationContext();
                sInstance = MPConfig.readConfig(appContext);
            }
        }
        return sInstance;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory factory) {
        this.mSSLSocketFactory = factory;
    }

    public synchronized void setOfflineMode(OfflineMode offlineMode) {
        this.mOfflineMode = offlineMode;
    }

    MPConfig(Bundle metaData, Context context) {
        SSLSocketFactory foundSSLFactory;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            foundSSLFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            MPLog.i(LOGTAG, "System has no SSL support. Built-in events editor will not be available", e);
            foundSSLFactory = null;
        }
        this.mSSLSocketFactory = foundSSLFactory;
        DEBUG = metaData.getBoolean("com.mixpanel.android.MPConfig.EnableDebugLogging", false);
        if (metaData.containsKey("com.mixpanel.android.MPConfig.DebugFlushInterval")) {
            MPLog.w(LOGTAG, "We do not support com.mixpanel.android.MPConfig.DebugFlushInterval anymore. There will only be one flush interval. Please, update your AndroidManifest.xml.");
        }
        this.mBulkUploadLimit = metaData.getInt("com.mixpanel.android.MPConfig.BulkUploadLimit", 40);
        this.mFlushInterval = metaData.getInt("com.mixpanel.android.MPConfig.FlushInterval", 60000);
        this.mDataExpiration = metaData.getInt("com.mixpanel.android.MPConfig.DataExpiration", 432000000);
        this.mMinimumDatabaseLimit = metaData.getInt("com.mixpanel.android.MPConfig.MinimumDatabaseLimit", 0x1400000);
        this.mDisableFallback = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableFallback", true);
        this.mResourcePackageName = metaData.getString("com.mixpanel.android.MPConfig.ResourcePackageName");
        this.mDisableGestureBindingUI = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableGestureBindingUI", false);
        this.mDisableEmulatorBindingUI = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableEmulatorBindingUI", false);
        this.mDisableAppOpenEvent = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableAppOpenEvent", true);
        this.mDisableViewCrawler = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableViewCrawler", false);
        this.mDisableDecideChecker = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableDecideChecker", false);
        this.mImageCacheMaxMemoryFactor = metaData.getInt("com.mixpanel.android.MPConfig.ImageCacheMaxMemoryFactor", 10);
        this.mIgnoreInvisibleViewsEditor = metaData.getBoolean("com.mixpanel.android.MPConfig.IgnoreInvisibleViewsVisualEditor", false);
        this.mAutoShowMixpanelUpdates = metaData.getBoolean("com.mixpanel.android.MPConfig.AutoShowMixpanelUpdates", true);
        this.mTestMode = metaData.getBoolean("com.mixpanel.android.MPConfig.TestMode", false);
        String eventsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsEndpoint");
        if (null == eventsEndpoint) {
            eventsEndpoint = "https://api.mixpanel.com/track?ip=1";
        }
        this.mEventsEndpoint = eventsEndpoint;
        String eventsFallbackEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsFallbackEndpoint");
        if (null == eventsFallbackEndpoint) {
            eventsFallbackEndpoint = "http://api.mixpanel.com/track?ip=1";
        }
        this.mEventsFallbackEndpoint = eventsFallbackEndpoint;
        String peopleEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleEndpoint");
        if (null == peopleEndpoint) {
            peopleEndpoint = "https://api.mixpanel.com/engage";
        }
        this.mPeopleEndpoint = peopleEndpoint;
        String peopleFallbackEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleFallbackEndpoint");
        if (null == peopleFallbackEndpoint) {
            peopleFallbackEndpoint = "http://api.mixpanel.com/engage";
        }
        this.mPeopleFallbackEndpoint = peopleFallbackEndpoint;
        String decideEndpoint = metaData.getString("com.mixpanel.android.MPConfig.DecideEndpoint");
        if (null == decideEndpoint) {
            decideEndpoint = "https://decide.mixpanel.com/decide";
        }
        this.mDecideEndpoint = decideEndpoint;
        String decideFallbackEndpoint = metaData.getString("com.mixpanel.android.MPConfig.DecideFallbackEndpoint");
        if (null == decideFallbackEndpoint) {
            decideFallbackEndpoint = "http://decide.mixpanel.com/decide";
        }
        this.mDecideFallbackEndpoint = decideFallbackEndpoint;
        String editorUrl = metaData.getString("com.mixpanel.android.MPConfig.EditorUrl");
        if (null == editorUrl) {
            editorUrl = "wss://switchboard.mixpanel.com/connect/";
        }
        this.mEditorUrl = editorUrl;
        int resourceId = metaData.getInt("com.mixpanel.android.MPConfig.DisableViewCrawlerForProjects", -1);
        this.mDisableViewCrawlerForProjects = resourceId != -1 ? context.getResources().getStringArray(resourceId) : new String[0];
        MPLog.v(LOGTAG, "Mixpanel (5.0.0) configured with:\n    AutoShowMixpanelUpdates " + this.getAutoShowMixpanelUpdates() + "\n    BulkUploadLimit " + this.getBulkUploadLimit() + "\n    FlushInterval " + this.getFlushInterval() + "\n    DataExpiration " + this.getDataExpiration() + "\n    MinimumDatabaseLimit " + this.getMinimumDatabaseLimit() + "\n    DisableFallback " + this.getDisableFallback() + "\n    DisableAppOpenEvent " + this.getDisableAppOpenEvent() + "\n    DisableViewCrawler " + this.getDisableViewCrawler() + "\n    DisableDeviceUIBinding " + this.getDisableGestureBindingUI() + "\n    DisableEmulatorUIBinding " + this.getDisableEmulatorBindingUI() + "\n    EnableDebugLogging " + DEBUG + "\n    TestMode " + this.getTestMode() + "\n    EventsEndpoint " + this.getEventsEndpoint() + "\n    PeopleEndpoint " + this.getPeopleEndpoint() + "\n    DecideEndpoint " + this.getDecideEndpoint() + "\n    EventsFallbackEndpoint " + this.getEventsFallbackEndpoint() + "\n    PeopleFallbackEndpoint " + this.getPeopleFallbackEndpoint() + "\n    DecideFallbackEndpoint " + this.getDecideFallbackEndpoint() + "\n    EditorUrl " + this.getEditorUrl() + "\n    DisableDecideChecker " + this.getDisableDecideChecker() + "\n    IgnoreInvisibleViewsEditor " + this.getIgnoreInvisibleViewsEditor() + "\n");
    }

    public int getBulkUploadLimit() {
        return this.mBulkUploadLimit;
    }

    public int getFlushInterval() {
        return this.mFlushInterval;
    }

    public int getDataExpiration() {
        return this.mDataExpiration;
    }

    public int getMinimumDatabaseLimit() {
        return this.mMinimumDatabaseLimit;
    }

    public boolean getDisableFallback() {
        return this.mDisableFallback;
    }

    public boolean getDisableGestureBindingUI() {
        return this.mDisableGestureBindingUI;
    }

    public boolean getDisableEmulatorBindingUI() {
        return this.mDisableEmulatorBindingUI;
    }

    public boolean getDisableAppOpenEvent() {
        return this.mDisableAppOpenEvent;
    }

    public boolean getDisableViewCrawler() {
        return this.mDisableViewCrawler;
    }

    public String[] getDisableViewCrawlerForProjects() {
        return this.mDisableViewCrawlerForProjects;
    }

    public boolean getTestMode() {
        return this.mTestMode;
    }

    public String getEventsEndpoint() {
        return this.mEventsEndpoint;
    }

    public String getPeopleEndpoint() {
        return this.mPeopleEndpoint;
    }

    public String getDecideEndpoint() {
        return this.mDecideEndpoint;
    }

    public String getEventsFallbackEndpoint() {
        return this.mEventsFallbackEndpoint;
    }

    public String getPeopleFallbackEndpoint() {
        return this.mPeopleFallbackEndpoint;
    }

    public String getDecideFallbackEndpoint() {
        return this.mDecideFallbackEndpoint;
    }

    public boolean getAutoShowMixpanelUpdates() {
        return this.mAutoShowMixpanelUpdates;
    }

    public String getEditorUrl() {
        return this.mEditorUrl;
    }

    public boolean getDisableDecideChecker() {
        return this.mDisableDecideChecker;
    }

    public boolean getIgnoreInvisibleViewsEditor() {
        return this.mIgnoreInvisibleViewsEditor;
    }

    public String getResourcePackageName() {
        return this.mResourcePackageName;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public synchronized OfflineMode getOfflineMode() {
        return this.mOfflineMode;
    }

    public int getImageCacheMaxMemoryFactor() {
        return this.mImageCacheMaxMemoryFactor;
    }

    static MPConfig readConfig(Context appContext) {
        String packageName = appContext.getPackageName();
        try {
            ApplicationInfo appInfo = appContext.getPackageManager().getApplicationInfo(packageName, 128);
            Bundle configBundle = appInfo.metaData;
            if (null == configBundle) {
                configBundle = new Bundle();
            }
            return new MPConfig(configBundle, appContext);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Can't configure Mixpanel with package name " + packageName, e);
        }
    }

    static {
        sInstanceLock = new Object();
    }
}

