/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.takeoverinapp;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.InAppButton;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.TakeoverInAppNotification;
import com.mixpanel.android.mpmetrics.UpdateDisplayState;
import com.mixpanel.android.takeoverinapp.FadingImageView;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.ViewUtils;
import java.util.ArrayList;

@TargetApi(value=16)
@SuppressLint(value={"ClickableViewAccessibility"})
public class TakeoverInAppActivity
extends Activity {
    private MixpanelAPI mMixpanel;
    private UpdateDisplayState mUpdateDisplayState;
    private int mIntentId = -1;
    private static final String LOGTAG = "MixpanelAPI.TakeoverInAppActivity";
    public static final String INTENT_ID_KEY = "com.mixpanel.android.takeoverinapp.TakeoverInAppActivity.INTENT_ID_KEY";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mIntentId = this.getIntent().getIntExtra(INTENT_ID_KEY, Integer.MAX_VALUE);
        this.mUpdateDisplayState = UpdateDisplayState.claimDisplayState(this.mIntentId);
        if (null == this.mUpdateDisplayState) {
            MPLog.e(LOGTAG, "TakeoverInAppActivity intent received, but nothing was found to show.");
            this.finish();
            return;
        }
        this.mMixpanel = MixpanelAPI.getInstance((Context)this, this.mUpdateDisplayState.getToken());
        this.onCreateInAppNotification();
    }

    private void onCreateInAppNotification() {
        this.setContentView(R.layout.com_mixpanel_android_activity_notification_full);
        ImageView backgroundImage = (ImageView)this.findViewById(R.id.com_mixpanel_android_notification_gradient);
        FadingImageView inAppImageView = (FadingImageView)this.findViewById(R.id.com_mixpanel_android_notification_image);
        TextView titleView = (TextView)this.findViewById(R.id.com_mixpanel_android_notification_title);
        TextView subtextView = (TextView)this.findViewById(R.id.com_mixpanel_android_notification_subtext);
        ArrayList<Button> ctaButtons = new ArrayList<Button>();
        Button ctaButton = (Button)this.findViewById(R.id.com_mixpanel_android_notification_button);
        ctaButtons.add(ctaButton);
        Button secondCtaButton = (Button)this.findViewById(R.id.com_mixpanel_android_notification_second_button);
        ctaButtons.add(secondCtaButton);
        LinearLayout closeButtonWrapper = (LinearLayout)this.findViewById(R.id.com_mixpanel_android_button_exit_wrapper);
        ImageView closeButtonImageView = (ImageView)this.findViewById(R.id.com_mixpanel_android_image_close);
        UpdateDisplayState.DisplayState.InAppNotificationState notificationState = (UpdateDisplayState.DisplayState.InAppNotificationState)this.mUpdateDisplayState.getDisplayState();
        TakeoverInAppNotification inApp = (TakeoverInAppNotification)notificationState.getInAppNotification();
        Display display = this.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        if (this.getResources().getConfiguration().orientation == 1) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)closeButtonWrapper.getLayoutParams();
            params.setMargins(0, 0, 0, (int)((float)size.y * 0.06f));
            closeButtonWrapper.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        inAppImageView.showShadow(inApp.setShouldShowShadow());
        backgroundImage.setBackgroundColor(inApp.getBackgroundColor());
        if (inApp.hasTitle()) {
            titleView.setVisibility(0);
            titleView.setText((CharSequence)inApp.getTitle());
            titleView.setTextColor(inApp.getTitleColor());
        } else {
            titleView.setVisibility(8);
        }
        if (inApp.hasBody()) {
            subtextView.setVisibility(0);
            subtextView.setText((CharSequence)inApp.getBody());
            subtextView.setTextColor(inApp.getBodyColor());
        } else {
            subtextView.setVisibility(8);
        }
        inAppImageView.setImageBitmap(inApp.getImage());
        for (int i = 0; i < ctaButtons.size(); ++i) {
            InAppButton inAppButtonModel = inApp.getButton(i);
            Button inAppButton = (Button)ctaButtons.get(i);
            this.setUpInAppButton(inAppButton, inAppButtonModel, inApp);
        }
        if (inApp.getNumButtons() == 1) {
            LinearLayout.LayoutParams oneButtonLayoutParams = (LinearLayout.LayoutParams)ctaButton.getLayoutParams();
            oneButtonLayoutParams.weight = 0.0f;
            oneButtonLayoutParams.width = -2;
            ctaButton.setLayoutParams((ViewGroup.LayoutParams)oneButtonLayoutParams);
        }
        closeButtonImageView.setColorFilter(inApp.getCloseColor());
        closeButtonWrapper.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakeoverInAppActivity.this.finish();
                UpdateDisplayState.releaseDisplayState(TakeoverInAppActivity.this.mIntentId);
            }
        });
        this.setUpNotificationAnimations(inAppImageView, titleView, subtextView, ctaButtons, closeButtonWrapper);
    }

    private void setUpInAppButton(Button inAppButton, final InAppButton inAppButtonModel, final InAppNotification inApp) {
        if (inAppButtonModel != null) {
            inAppButton.setVisibility(0);
            inAppButton.setText((CharSequence)inAppButtonModel.getText());
            inAppButton.setTextColor(inAppButtonModel.getTextColor());
            inAppButton.setTransformationMethod(null);
            final GradientDrawable buttonBackground = new GradientDrawable();
            final int highlightColor = inAppButtonModel.getBackgroundColor() != 0 ? ViewUtils.mixColors(inAppButtonModel.getBackgroundColor(), 0x33868686) : 0x33868686;
            inAppButton.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        int highLight = highlightColor;
                        buttonBackground.setColor(highLight);
                    } else {
                        buttonBackground.setColor(inAppButtonModel.getBackgroundColor());
                    }
                    return false;
                }
            });
            buttonBackground.setColor(inAppButtonModel.getBackgroundColor());
            buttonBackground.setStroke((int)ViewUtils.dpToPx(2.0f, (Context)this), inAppButtonModel.getBorderColor());
            buttonBackground.setCornerRadius((float)((int)ViewUtils.dpToPx(5.0f, (Context)this)));
            if (Build.VERSION.SDK_INT < 16) {
                inAppButton.setBackgroundDrawable((Drawable)buttonBackground);
            } else {
                inAppButton.setBackground((Drawable)buttonBackground);
            }
            inAppButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String uriString = inAppButtonModel.getCtaUrl();
                    if (uriString != null && uriString.length() > 0) {
                        Uri uri;
                        try {
                            uri = Uri.parse((String)uriString);
                        }
                        catch (IllegalArgumentException e) {
                            MPLog.i(TakeoverInAppActivity.LOGTAG, "Can't parse notification URI, will not take any action", e);
                            return;
                        }
                        try {
                            Intent viewIntent = new Intent("android.intent.action.VIEW", uri);
                            TakeoverInAppActivity.this.startActivity(viewIntent);
                            TakeoverInAppActivity.this.mMixpanel.getPeople().trackNotification("$campaign_open", inApp);
                        }
                        catch (ActivityNotFoundException e) {
                            MPLog.i(TakeoverInAppActivity.LOGTAG, "User doesn't have an activity for notification URI");
                        }
                    }
                    TakeoverInAppActivity.this.finish();
                    UpdateDisplayState.releaseDisplayState(TakeoverInAppActivity.this.mIntentId);
                }
            });
        } else {
            inAppButton.setVisibility(8);
        }
    }

    private void setUpNotificationAnimations(ImageView notificationImage, TextView notificationTitle, TextView notificationBody, ArrayList<Button> ctaButtons, LinearLayout closeButtonWrapper) {
        ScaleAnimation scale = new ScaleAnimation(0.95f, 1.0f, 0.95f, 1.0f, 1, 0.5f, 1, 1.0f);
        scale.setDuration(200L);
        notificationImage.startAnimation((Animation)scale);
        TranslateAnimation translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.5f, 1, 0.0f);
        translate.setInterpolator((Interpolator)new DecelerateInterpolator());
        translate.setDuration(200L);
        notificationTitle.startAnimation((Animation)translate);
        notificationBody.startAnimation((Animation)translate);
        for (Button ctaButton : ctaButtons) {
            ctaButton.startAnimation((Animation)translate);
        }
        Animation fadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.com_mixpanel_android_fade_in);
        closeButtonWrapper.startAnimation(fadeIn);
    }

    public void onBackPressed() {
        UpdateDisplayState.releaseDisplayState(this.mIntentId);
        super.onBackPressed();
    }
}

