/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.InAppButton;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.util.JSONUtils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TakeoverInAppNotification
extends InAppNotification {
    private final ArrayList<InAppButton> mButtons;
    private final int mCloseButtonColor;
    private final String mTitle;
    private final int mTitleColor;
    private final boolean mShouldFadeImage;
    public static final Parcelable.Creator<TakeoverInAppNotification> CREATOR = new Parcelable.Creator<TakeoverInAppNotification>(){

        public TakeoverInAppNotification createFromParcel(Parcel source) {
            return new TakeoverInAppNotification(source);
        }

        public TakeoverInAppNotification[] newArray(int size) {
            return new TakeoverInAppNotification[size];
        }
    };

    public TakeoverInAppNotification(Parcel in) {
        super(in);
        this.mButtons = in.createTypedArrayList(InAppButton.CREATOR);
        this.mCloseButtonColor = in.readInt();
        this.mTitle = in.readString();
        this.mTitleColor = in.readInt();
        this.mShouldFadeImage = in.readByte() != 0;
    }

    TakeoverInAppNotification(JSONObject description) throws BadDecideObjectException {
        super(description);
        try {
            JSONArray buttonsArray = description.getJSONArray("buttons");
            this.mButtons = new ArrayList();
            for (int i = 0; i < buttonsArray.length(); ++i) {
                JSONObject buttonJson = (JSONObject)buttonsArray.get(i);
                this.mButtons.add(new InAppButton(buttonJson));
            }
            this.mCloseButtonColor = description.getInt("close_color");
            this.mTitle = JSONUtils.optionalStringKey(description, "title");
            this.mTitleColor = description.optInt("title_color");
            this.mShouldFadeImage = this.getExtras().getBoolean("image_fade");
        }
        catch (JSONException e) {
            throw new BadDecideObjectException("Notification JSON was unexpected or bad", e);
        }
    }

    public boolean hasTitle() {
        return this.mTitle != null;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public int getTitleColor() {
        return this.mTitleColor;
    }

    public int getCloseColor() {
        return this.mCloseButtonColor;
    }

    public InAppButton getButton(int index) {
        return this.mButtons.size() > index ? this.mButtons.get(index) : null;
    }

    public int getNumButtons() {
        return this.mButtons.size();
    }

    public boolean setShouldShowShadow() {
        return this.mShouldFadeImage;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.mButtons);
        dest.writeInt(this.mCloseButtonColor);
        dest.writeString(this.mTitle);
        dest.writeInt(this.mTitleColor);
        dest.writeByte((byte)(this.mShouldFadeImage ? 1 : 0));
    }

    @Override
    public InAppNotification.Type getType() {
        return InAppNotification.Type.TAKEOVER;
    }
}

