/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import com.mixpanel.android.mpmetrics.Tweak;
import com.mixpanel.android.util.MPLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Tweaks {
    public static final int BOOLEAN_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int LONG_TYPE = 3;
    public static final int STRING_TYPE = 4;
    private final ConcurrentMap<String, TweakValue> mTweakValues = new ConcurrentHashMap<String, TweakValue>();
    private final ConcurrentMap<String, TweakValue> mTweakDefaultValues = new ConcurrentHashMap<String, TweakValue>();
    private final ConcurrentMap<String, TweakValue> mUndeclaredTweaks = new ConcurrentHashMap<String, TweakValue>();
    private final List<OnTweakDeclaredListener> mTweakDeclaredListeners = new ArrayList<OnTweakDeclaredListener>();
    private static final String LOGTAG = "MixpanelAPI.Tweaks";

    public synchronized void addOnTweakDeclaredListener(OnTweakDeclaredListener listener) {
        if (null == listener) {
            throw new NullPointerException("listener cannot be null");
        }
        this.mTweakDeclaredListeners.add(listener);
    }

    public synchronized void set(String tweakName, Object value) {
        if (!this.mTweakValues.containsKey(tweakName)) {
            MPLog.w(LOGTAG, "Attempt to set a tweak \"" + tweakName + "\" which has never been defined.");
            return;
        }
        TweakValue container = (TweakValue)this.mTweakValues.get(tweakName);
        TweakValue updated = container.updateValue(value);
        this.mTweakValues.put(tweakName, updated);
    }

    public synchronized boolean isNewValue(String tweakName, Object value) {
        if (!this.mTweakValues.containsKey(tweakName)) {
            return false;
        }
        TweakValue container = (TweakValue)this.mTweakValues.get(tweakName);
        return !container.value.equals(value);
    }

    public synchronized Map<String, TweakValue> getAllValues() {
        return new HashMap<String, TweakValue>(this.mTweakValues);
    }

    public synchronized Map<String, TweakValue> getDefaultValues() {
        return new HashMap<String, TweakValue>(this.mTweakDefaultValues);
    }

    Tweaks() {
    }

    Tweak<String> stringTweak(final String tweakName, String defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 4);
        return new Tweak<String>(){

            @Override
            public String get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                return tweakValue.getStringValue();
            }
        };
    }

    Tweak<Double> doubleTweak(final String tweakName, double defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 2);
        return new Tweak<Double>(){

            @Override
            public Double get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.doubleValue();
            }
        };
    }

    Tweak<Double> doubleTweak(final String tweakName, double defaultValue, double minimumValue, double maximumValue) {
        this.declareTweak(tweakName, defaultValue, minimumValue, maximumValue, 2);
        return new Tweak<Double>(){

            @Override
            public Double get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.doubleValue();
            }
        };
    }

    Tweak<Float> floatTweak(final String tweakName, float defaultValue) {
        this.declareTweak(tweakName, Float.valueOf(defaultValue), null, null, 2);
        return new Tweak<Float>(){

            @Override
            public Float get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return Float.valueOf(result.floatValue());
            }
        };
    }

    Tweak<Float> floatTweak(final String tweakName, float defaultValue, float minimumValue, float maximumValue) {
        this.declareTweak(tweakName, Float.valueOf(defaultValue), Float.valueOf(minimumValue), Float.valueOf(maximumValue), 2);
        return new Tweak<Float>(){

            @Override
            public Float get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return Float.valueOf(result.floatValue());
            }
        };
    }

    Tweak<Long> longTweak(final String tweakName, long defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 3);
        return new Tweak<Long>(){

            @Override
            public Long get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.longValue();
            }
        };
    }

    Tweak<Long> longTweak(final String tweakName, long defaultValue, long minimumValue, long maximumValue) {
        this.declareTweak(tweakName, defaultValue, minimumValue, maximumValue, 3);
        return new Tweak<Long>(){

            @Override
            public Long get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.longValue();
            }
        };
    }

    Tweak<Integer> intTweak(final String tweakName, int defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 3);
        return new Tweak<Integer>(){

            @Override
            public Integer get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.intValue();
            }
        };
    }

    Tweak<Integer> intTweak(final String tweakName, int defaultValue, int minimumValue, int maximumValue) {
        this.declareTweak(tweakName, defaultValue, minimumValue, maximumValue, 3);
        return new Tweak<Integer>(){

            @Override
            public Integer get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.intValue();
            }
        };
    }

    Tweak<Byte> byteTweak(final String tweakName, byte defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 3);
        return new Tweak<Byte>(){

            @Override
            public Byte get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.byteValue();
            }
        };
    }

    Tweak<Short> shortTweak(final String tweakName, short defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 3);
        return new Tweak<Short>(){

            @Override
            public Short get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.shortValue();
            }
        };
    }

    Tweak<Boolean> booleanTweak(final String tweakName, boolean defaultValue) {
        this.declareTweak(tweakName, defaultValue, null, null, 1);
        return new Tweak<Boolean>(){

            @Override
            public Boolean get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                return tweakValue.getBooleanValue();
            }
        };
    }

    private synchronized TweakValue getValue(String tweakName) {
        return (TweakValue)this.mTweakValues.get(tweakName);
    }

    public void addUndeclaredTweak(String tweakName, TweakValue notDeclaredTweak) {
        if (tweakName == null || notDeclaredTweak == null) {
            return;
        }
        this.mUndeclaredTweaks.put(tweakName, notDeclaredTweak);
    }

    public void declareTweak(String tweakName, Object defaultValue, Number minimumValue, Number maximumValue, int tweakType) {
        TweakValue value;
        if (this.mTweakValues.containsKey(tweakName)) {
            MPLog.w(LOGTAG, "Attempt to define a tweak \"" + tweakName + "\" twice with the same name");
            return;
        }
        if (this.mUndeclaredTweaks.containsKey(tweakName)) {
            value = (TweakValue)this.mUndeclaredTweaks.get(tweakName);
            this.mUndeclaredTweaks.remove(tweakName);
        } else {
            value = new TweakValue(tweakType, defaultValue, minimumValue, maximumValue, defaultValue, tweakName);
        }
        this.mTweakValues.put(tweakName, value);
        this.mTweakDefaultValues.put(tweakName, value);
        int listenerSize = this.mTweakDeclaredListeners.size();
        for (int i = 0; i < listenerSize; ++i) {
            this.mTweakDeclaredListeners.get(i).onTweakDeclared();
        }
    }

    public static interface OnTweakDeclaredListener {
        public void onTweakDeclared();
    }

    public static class TweakValue {
        public final int type;
        private final Object value;
        private final Object defaultValue;
        private final Number minimum;
        private final Number maximum;
        private final String name;

        private TweakValue(int aType, Object aDefaultValue, Number aMin, Number aMax, Object value, String aName) {
            this.type = aType;
            this.name = aName;
            this.minimum = aMin;
            this.maximum = aMax;
            if (this.minimum != null && this.maximum != null) {
                if (!this.isBetweenBounds(aDefaultValue)) {
                    aDefaultValue = Math.min(Math.max(((Number)aDefaultValue).longValue(), this.minimum.longValue()), this.maximum.longValue());
                    MPLog.w(Tweaks.LOGTAG, "Attempt to define a tweak \"" + this.name + "\" with default value " + aDefaultValue + " out of its bounds [" + this.minimum + ", " + this.maximum + "]Tweak \"" + this.name + "\" new default value: " + aDefaultValue + ".");
                }
                if (!this.isBetweenBounds(value)) {
                    value = Math.min(Math.max(((Number)value).longValue(), this.minimum.longValue()), this.maximum.longValue());
                    MPLog.w(Tweaks.LOGTAG, "Attempt to define a tweak \"" + this.name + "\" with value " + aDefaultValue + " out of its bounds [" + this.minimum + ", " + this.maximum + "]Tweak \"" + this.name + "\" new value: " + value + ".");
                }
            }
            this.defaultValue = aDefaultValue;
            this.value = value;
        }

        private boolean isBetweenBounds(Object aValue) {
            try {
                Number aNumberValue = (Number)aValue;
                if (Math.min(Math.max(aNumberValue.longValue(), this.minimum.longValue()), this.maximum.longValue()) == this.minimum.longValue() || Math.min(Math.max(aNumberValue.longValue(), this.minimum.longValue()), this.maximum.longValue()) == this.maximum.longValue()) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return true;
        }

        public TweakValue updateValue(Object newValue) {
            return new TweakValue(this.type, this.defaultValue, this.minimum, this.maximum, newValue, this.name);
        }

        public String getStringValue() {
            String ret = null;
            try {
                ret = (String)this.defaultValue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            try {
                ret = (String)this.value;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return ret;
        }

        public Number getNumberValue() {
            Number ret = 0;
            if (null != this.defaultValue) {
                try {
                    ret = (Number)this.defaultValue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (null != this.value) {
                try {
                    ret = (Number)this.value;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return ret;
        }

        public Boolean getBooleanValue() {
            Boolean ret = false;
            if (null != this.defaultValue) {
                try {
                    ret = (Boolean)this.defaultValue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (null != this.value) {
                try {
                    ret = (Boolean)this.value;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return ret;
        }

        public Number getMinimum() {
            return this.minimum;
        }

        public Number getMaximum() {
            return this.maximum;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Object getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static TweakValue fromJson(JSONObject tweakDesc) {
            try {
                void var6_13;
                void var5_9;
                Object defaultValue;
                Object value;
                int tweakType;
                String tweakName = tweakDesc.getString("name");
                String type = tweakDesc.getString("type");
                Object var5_4 = null;
                Object var6_10 = null;
                if ("number".equals(type)) {
                    String encoding = tweakDesc.getString("encoding");
                    if ("d".equals(encoding)) {
                        tweakType = 2;
                        value = tweakDesc.getDouble("value");
                        defaultValue = tweakDesc.getDouble("default");
                        if (!tweakDesc.isNull("minimum")) {
                            Double d = tweakDesc.getDouble("minimum");
                        }
                        if (tweakDesc.isNull("maximum")) return new TweakValue(tweakType, defaultValue, (Number)var5_9, (Number)var6_13, value, tweakName);
                        Double d = tweakDesc.getDouble("maximum");
                        return new TweakValue(tweakType, defaultValue, (Number)var5_9, (Number)var6_13, value, tweakName);
                    } else {
                        if (!"l".equals(encoding)) return null;
                        value = tweakDesc.getLong("value");
                        tweakType = 3;
                        defaultValue = tweakDesc.getLong("default");
                        if (!tweakDesc.isNull("minimum")) {
                            Long l = tweakDesc.getLong("minimum");
                        }
                        if (tweakDesc.isNull("maximum")) return new TweakValue(tweakType, defaultValue, (Number)var5_9, (Number)var6_13, value, tweakName);
                        Long l = tweakDesc.getLong("maximum");
                    }
                    return new TweakValue(tweakType, defaultValue, (Number)var5_9, (Number)var6_13, value, tweakName);
                } else if ("boolean".equals(type)) {
                    tweakType = 1;
                    value = tweakDesc.getBoolean("value");
                    defaultValue = tweakDesc.getBoolean("default");
                    return new TweakValue(tweakType, defaultValue, (Number)var5_9, (Number)var6_13, value, tweakName);
                } else {
                    if (!"string".equals(type)) return null;
                    tweakType = 4;
                    value = tweakDesc.getString("value");
                    defaultValue = tweakDesc.getString("default");
                }
                return new TweakValue(tweakType, defaultValue, (Number)var5_9, (Number)var6_13, value, tweakName);
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
    }
}

