/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.Base64Coder;
import com.mixpanel.android.util.HttpService;
import com.mixpanel.android.util.LegacyVersionUtils;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.RemoteService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

class AnalyticsMessages {
    private final Worker mWorker;
    protected final Context mContext;
    protected final MPConfig mConfig;
    private static final int ENQUEUE_PEOPLE = 0;
    private static final int ENQUEUE_EVENTS = 1;
    private static final int FLUSH_QUEUE = 2;
    private static final int ENQUEUE_GROUP = 3;
    private static final int PUSH_ANONYMOUS_PEOPLE_RECORDS = 4;
    private static final int KILL_WORKER = 5;
    private static final int EMPTY_QUEUES = 6;
    private static final int CLEAR_ANONYMOUS_UPDATES = 7;
    private static final int REWRITE_EVENT_PROPERTIES = 8;
    private static final int REMOVE_RESIDUAL_IMAGE_FILES = 9;
    private static final String LOGTAG = "MixpanelAPI.Messages";
    private static final Map<Context, AnalyticsMessages> sInstances = new HashMap<Context, AnalyticsMessages>();

    AnalyticsMessages(Context context) {
        this.mContext = context;
        this.mConfig = this.getConfig(context);
        this.mWorker = this.createWorker();
        this.getPoster().checkIsMixpanelBlocked();
    }

    protected Worker createWorker() {
        return new Worker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsMessages getInstance(Context messageContext) {
        Map<Context, AnalyticsMessages> map = sInstances;
        synchronized (map) {
            AnalyticsMessages ret;
            Context appContext = messageContext.getApplicationContext();
            if (!sInstances.containsKey(appContext)) {
                ret = new AnalyticsMessages(appContext);
                sInstances.put(appContext, ret);
            } else {
                ret = sInstances.get(appContext);
            }
            return ret;
        }
    }

    public void eventsMessage(EventDescription eventDescription) {
        Message m = Message.obtain();
        m.what = 1;
        m.obj = eventDescription;
        this.mWorker.runMessage(m);
    }

    public void peopleMessage(PeopleDescription peopleDescription) {
        Message m = Message.obtain();
        m.what = 0;
        m.obj = peopleDescription;
        this.mWorker.runMessage(m);
    }

    public void groupMessage(GroupDescription groupDescription) {
        Message m = Message.obtain();
        m.what = 3;
        m.obj = groupDescription;
        this.mWorker.runMessage(m);
    }

    public void pushAnonymousPeopleMessage(PushAnonymousPeopleDescription pushAnonymousPeopleDescription) {
        Message m = Message.obtain();
        m.what = 4;
        m.obj = pushAnonymousPeopleDescription;
        this.mWorker.runMessage(m);
    }

    public void clearAnonymousUpdatesMessage(MixpanelDescription clearAnonymousUpdatesDescription) {
        Message m = Message.obtain();
        m.what = 7;
        m.obj = clearAnonymousUpdatesDescription;
        this.mWorker.runMessage(m);
    }

    public void postToServer(MixpanelDescription flushDescription) {
        Message m = Message.obtain();
        m.what = 2;
        m.obj = flushDescription.getToken();
        m.arg1 = 0;
        this.mWorker.runMessage(m);
    }

    public void emptyTrackingQueues(MixpanelDescription mixpanelDescription) {
        Message m = Message.obtain();
        m.what = 6;
        m.obj = mixpanelDescription;
        this.mWorker.runMessage(m);
    }

    public void updateEventProperties(UpdateEventsPropertiesDescription updateEventsProperties) {
        Message m = Message.obtain();
        m.what = 8;
        m.obj = updateEventsProperties;
        this.mWorker.runMessage(m);
    }

    public void removeResidualImageFiles(File fileOrDirectory) {
        Message m = Message.obtain();
        m.what = 9;
        m.obj = fileOrDirectory;
        this.mWorker.runMessage(m);
    }

    public void hardKill() {
        Message m = Message.obtain();
        m.what = 5;
        this.mWorker.runMessage(m);
    }

    boolean isDead() {
        return this.mWorker.isDead();
    }

    protected MPDbAdapter makeDbAdapter(Context context) {
        return MPDbAdapter.getInstance(context);
    }

    protected MPConfig getConfig(Context context) {
        return MPConfig.getInstance(context);
    }

    protected RemoteService getPoster() {
        return new HttpService();
    }

    private void logAboutMessageToMixpanel(String message) {
        MPLog.v(LOGTAG, message + " (Thread " + Thread.currentThread().getId() + ")");
    }

    private void logAboutMessageToMixpanel(String message, Throwable e) {
        MPLog.v(LOGTAG, message + " (Thread " + Thread.currentThread().getId() + ")", e);
    }

    public long getTrackEngageRetryAfter() {
        return ((Worker.AnalyticsMessageHandler)this.mWorker.mHandler).getTrackEngageRetryAfter();
    }

    class Worker {
        private final Object mHandlerLock = new Object();
        private Handler mHandler = this.restartWorkerThread();
        private long mFlushCount = 0L;
        private long mAveFlushFrequency = 0L;
        private long mLastFlushTime = -1L;
        private SystemInformation mSystemInformation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDead() {
            Object object = this.mHandlerLock;
            synchronized (object) {
                return this.mHandler == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runMessage(Message msg) {
            Object object = this.mHandlerLock;
            synchronized (object) {
                if (this.mHandler == null) {
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Dead mixpanel worker dropping a message: " + msg.what);
                } else {
                    this.mHandler.sendMessage(msg);
                }
            }
        }

        protected Handler restartWorkerThread() {
            HandlerThread thread = new HandlerThread("com.mixpanel.android.AnalyticsWorker", 10);
            thread.start();
            return new AnalyticsMessageHandler(thread.getLooper());
        }

        private void updateFlushFrequency() {
            long now = System.currentTimeMillis();
            long newFlushCount = this.mFlushCount + 1L;
            if (this.mLastFlushTime > 0L) {
                long flushInterval = now - this.mLastFlushTime;
                long totalFlushTime = flushInterval + this.mAveFlushFrequency * this.mFlushCount;
                this.mAveFlushFrequency = totalFlushTime / newFlushCount;
                long seconds = this.mAveFlushFrequency / 1000L;
                AnalyticsMessages.this.logAboutMessageToMixpanel("Average send frequency approximately " + seconds + " seconds.");
            }
            this.mLastFlushTime = now;
            this.mFlushCount = newFlushCount;
        }

        class AnalyticsMessageHandler
        extends Handler {
            private MPDbAdapter mDbAdapter;
            private final long mFlushInterval;
            private long mTrackEngageRetryAfter;
            private int mFailedRetries;

            public AnalyticsMessageHandler(Looper looper) {
                super(looper);
                this.mDbAdapter = null;
                Worker.this.mSystemInformation = SystemInformation.getInstance(AnalyticsMessages.this.mContext);
                this.mFlushInterval = AnalyticsMessages.this.mConfig.getFlushInterval();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (this.mDbAdapter == null) {
                    this.mDbAdapter = AnalyticsMessages.this.makeDbAdapter(AnalyticsMessages.this.mContext);
                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - AnalyticsMessages.this.mConfig.getDataExpiration(), MPDbAdapter.Table.EVENTS);
                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - AnalyticsMessages.this.mConfig.getDataExpiration(), MPDbAdapter.Table.PEOPLE);
                }
                try {
                    Object message;
                    int returnCode = -3;
                    String token = null;
                    if (msg.what == 0) {
                        message = (PeopleDescription)msg.obj;
                        MPDbAdapter.Table peopleTable = ((PeopleDescription)message).isAnonymous() ? MPDbAdapter.Table.ANONYMOUS_PEOPLE : MPDbAdapter.Table.PEOPLE;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing people record for sending later");
                        AnalyticsMessages.this.logAboutMessageToMixpanel("    " + ((PeopleDescription)message).toString());
                        token = ((MixpanelDescription)message).getToken();
                        int numRowsTable = this.mDbAdapter.addJSON(((MixpanelMessageDescription)message).getMessage(), token, peopleTable);
                        returnCode = ((PeopleDescription)message).isAnonymous() ? 0 : numRowsTable;
                    } else if (msg.what == 3) {
                        message = (GroupDescription)msg.obj;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing group record for sending later");
                        AnalyticsMessages.this.logAboutMessageToMixpanel("    " + ((GroupDescription)message).toString());
                        token = ((MixpanelDescription)message).getToken();
                        returnCode = this.mDbAdapter.addJSON(((MixpanelMessageDescription)message).getMessage(), token, MPDbAdapter.Table.GROUPS);
                    } else if (msg.what == 1) {
                        EventDescription eventDescription = (EventDescription)msg.obj;
                        try {
                            JSONObject message2 = this.prepareEventObject(eventDescription);
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing event for sending later");
                            AnalyticsMessages.this.logAboutMessageToMixpanel("    " + message2.toString());
                            token = eventDescription.getToken();
                            returnCode = this.mDbAdapter.addJSON(message2, token, MPDbAdapter.Table.EVENTS);
                        }
                        catch (JSONException e) {
                            MPLog.e(AnalyticsMessages.LOGTAG, "Exception tracking event " + eventDescription.getEventName(), e);
                        }
                    } else if (msg.what == 4) {
                        PushAnonymousPeopleDescription pushAnonymousPeopleDescription = (PushAnonymousPeopleDescription)msg.obj;
                        String distinctId = pushAnonymousPeopleDescription.getDistinctId();
                        token = pushAnonymousPeopleDescription.getToken();
                        returnCode = this.mDbAdapter.pushAnonymousUpdatesToPeopleDb(token, distinctId);
                    } else if (msg.what == 7) {
                        MixpanelDescription mixpanelDescription = (MixpanelDescription)msg.obj;
                        token = mixpanelDescription.getToken();
                        this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.ANONYMOUS_PEOPLE, token);
                    } else if (msg.what == 8) {
                        UpdateEventsPropertiesDescription description = (UpdateEventsPropertiesDescription)msg.obj;
                        int updatedEvents = this.mDbAdapter.rewriteEventDataWithProperties(description.getProperties(), description.getToken());
                        MPLog.d(AnalyticsMessages.LOGTAG, updatedEvents + " stored events were updated with new properties.");
                    } else if (msg.what == 2) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing queue due to scheduled or forced flush");
                        Worker.this.updateFlushFrequency();
                        token = (String)msg.obj;
                        this.sendAllData(this.mDbAdapter, token);
                    } else if (msg.what == 6) {
                        message = (MixpanelDescription)msg.obj;
                        token = ((MixpanelDescription)message).getToken();
                        this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.EVENTS, token);
                        this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.PEOPLE, token);
                        this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.GROUPS, token);
                        this.mDbAdapter.cleanupAllEvents(MPDbAdapter.Table.ANONYMOUS_PEOPLE, token);
                    } else if (msg.what == 5) {
                        MPLog.w(AnalyticsMessages.LOGTAG, "Worker received a hard kill. Dumping all events and force-killing. Thread id " + Thread.currentThread().getId());
                        message = Worker.this.mHandlerLock;
                        synchronized (message) {
                            this.mDbAdapter.deleteDB();
                            Worker.this.mHandler = null;
                            Looper.myLooper().quit();
                        }
                    } else if (msg.what == 9) {
                        File file = (File)msg.obj;
                        LegacyVersionUtils.removeLegacyResidualImageFiles(file);
                    } else {
                        MPLog.e(AnalyticsMessages.LOGTAG, "Unexpected message received by Mixpanel worker: " + msg);
                    }
                    if ((returnCode >= AnalyticsMessages.this.mConfig.getBulkUploadLimit() || returnCode == -2) && this.mFailedRetries <= 0 && token != null) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing queue due to bulk upload limit (" + returnCode + ") for project " + token);
                        Worker.this.updateFlushFrequency();
                        this.sendAllData(this.mDbAdapter, token);
                    } else if (returnCode > 0 && !this.hasMessages(2, token)) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queue depth " + returnCode + " - Adding flush in " + this.mFlushInterval);
                        if (this.mFlushInterval >= 0L) {
                            Message flushMessage = Message.obtain();
                            flushMessage.what = 2;
                            flushMessage.obj = token;
                            flushMessage.arg1 = 1;
                            this.sendMessageDelayed(flushMessage, this.mFlushInterval);
                        }
                    }
                }
                catch (RuntimeException e) {
                    MPLog.e(AnalyticsMessages.LOGTAG, "Worker threw an unhandled exception", e);
                    Object object = Worker.this.mHandlerLock;
                    synchronized (object) {
                        Worker.this.mHandler = null;
                        try {
                            Looper.myLooper().quit();
                            MPLog.e(AnalyticsMessages.LOGTAG, "Mixpanel will not process any more analytics messages", e);
                        }
                        catch (Exception tooLate) {
                            MPLog.e(AnalyticsMessages.LOGTAG, "Could not halt looper", tooLate);
                        }
                    }
                }
            }

            protected long getTrackEngageRetryAfter() {
                return this.mTrackEngageRetryAfter;
            }

            private void sendAllData(MPDbAdapter dbAdapter, String token) {
                RemoteService poster = AnalyticsMessages.this.getPoster();
                if (!poster.isOnline(AnalyticsMessages.this.mContext, AnalyticsMessages.this.mConfig.getOfflineMode())) {
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Not flushing data to Mixpanel because the device is not connected to the internet.");
                    return;
                }
                this.sendData(dbAdapter, token, MPDbAdapter.Table.EVENTS, AnalyticsMessages.this.mConfig.getEventsEndpoint());
                this.sendData(dbAdapter, token, MPDbAdapter.Table.PEOPLE, AnalyticsMessages.this.mConfig.getPeopleEndpoint());
                this.sendData(dbAdapter, token, MPDbAdapter.Table.GROUPS, AnalyticsMessages.this.mConfig.getGroupsEndpoint());
            }

            private void sendData(MPDbAdapter dbAdapter, String token, MPDbAdapter.Table table, String url) {
                RemoteService poster = AnalyticsMessages.this.getPoster();
                String[] eventsData = dbAdapter.generateDataString(table, token);
                Integer queueCount = 0;
                if (eventsData != null) {
                    queueCount = Integer.valueOf(eventsData[2]);
                }
                while (eventsData != null && queueCount > 0) {
                    boolean deleteEvents;
                    String lastId;
                    block14: {
                        lastId = eventsData[0];
                        String rawMessage = eventsData[1];
                        String encodedData = Base64Coder.encodeString(rawMessage);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("data", encodedData);
                        if (MPConfig.DEBUG) {
                            params.put("verbose", "1");
                        }
                        deleteEvents = true;
                        try {
                            String parsedResponse;
                            SSLSocketFactory socketFactory = AnalyticsMessages.this.mConfig.getSSLSocketFactory();
                            byte[] response = poster.performRequest(url, params, socketFactory);
                            if (null == response) {
                                deleteEvents = false;
                                AnalyticsMessages.this.logAboutMessageToMixpanel("Response was null, unexpected failure posting to " + url + ".");
                                break block14;
                            }
                            deleteEvents = true;
                            try {
                                parsedResponse = new String(response, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException("UTF not supported on this platform?", e);
                            }
                            if (this.mFailedRetries > 0) {
                                this.mFailedRetries = 0;
                                this.removeMessages(2, token);
                            }
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Successfully posted to " + url + ": \n" + rawMessage);
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Response was " + parsedResponse);
                        }
                        catch (OutOfMemoryError e) {
                            MPLog.e(AnalyticsMessages.LOGTAG, "Out of memory when posting to " + url + ".", e);
                        }
                        catch (MalformedURLException e) {
                            MPLog.e(AnalyticsMessages.LOGTAG, "Cannot interpret " + url + " as a URL.", e);
                        }
                        catch (RemoteService.ServiceUnavailableException e) {
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Cannot post message to " + url + ".", e);
                            deleteEvents = false;
                            this.mTrackEngageRetryAfter = e.getRetryAfter() * 1000;
                        }
                        catch (SocketTimeoutException e) {
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Cannot post message to " + url + ".", e);
                            deleteEvents = false;
                        }
                        catch (IOException e) {
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Cannot post message to " + url + ".", e);
                            deleteEvents = false;
                        }
                    }
                    if (!deleteEvents) {
                        this.removeMessages(2, token);
                        this.mTrackEngageRetryAfter = Math.max((long)Math.pow(2.0, this.mFailedRetries) * 60000L, this.mTrackEngageRetryAfter);
                        this.mTrackEngageRetryAfter = Math.min(this.mTrackEngageRetryAfter, 600000L);
                        Message flushMessage = Message.obtain();
                        flushMessage.what = 2;
                        flushMessage.obj = token;
                        this.sendMessageDelayed(flushMessage, this.mTrackEngageRetryAfter);
                        ++this.mFailedRetries;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Retrying this batch of events in " + this.mTrackEngageRetryAfter + " ms");
                        break;
                    }
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Not retrying this batch of events, deleting them from DB.");
                    dbAdapter.cleanupEvents(lastId, table, token);
                    eventsData = dbAdapter.generateDataString(table, token);
                    if (eventsData == null) continue;
                    queueCount = Integer.valueOf(eventsData[2]);
                }
            }

            private JSONObject getDefaultEventProperties() throws JSONException {
                String bluetoothVersion;
                Boolean isBluetoothEnabled;
                Boolean isWifi;
                String carrier;
                Boolean hasTelephony;
                Boolean hasNFC;
                Integer applicationVersionCode;
                JSONObject ret = new JSONObject();
                ret.put("mp_lib", (Object)"android");
                ret.put("$lib_version", (Object)"7.3.0");
                ret.put("$os", (Object)"Android");
                ret.put("$os_version", (Object)(Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE));
                ret.put("$manufacturer", (Object)(Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER));
                ret.put("$brand", (Object)(Build.BRAND == null ? "UNKNOWN" : Build.BRAND));
                ret.put("$model", (Object)(Build.MODEL == null ? "UNKNOWN" : Build.MODEL));
                DisplayMetrics displayMetrics = Worker.this.mSystemInformation.getDisplayMetrics();
                ret.put("$screen_dpi", displayMetrics.densityDpi);
                ret.put("$screen_height", displayMetrics.heightPixels);
                ret.put("$screen_width", displayMetrics.widthPixels);
                String applicationVersionName = Worker.this.mSystemInformation.getAppVersionName();
                if (null != applicationVersionName) {
                    ret.put("$app_version", (Object)applicationVersionName);
                    ret.put("$app_version_string", (Object)applicationVersionName);
                }
                if (null != (applicationVersionCode = Worker.this.mSystemInformation.getAppVersionCode())) {
                    String applicationVersion = String.valueOf(applicationVersionCode);
                    ret.put("$app_release", (Object)applicationVersion);
                    ret.put("$app_build_number", (Object)applicationVersion);
                }
                if (null != (hasNFC = Boolean.valueOf(Worker.this.mSystemInformation.hasNFC()))) {
                    ret.put("$has_nfc", hasNFC.booleanValue());
                }
                if (null != (hasTelephony = Boolean.valueOf(Worker.this.mSystemInformation.hasTelephony()))) {
                    ret.put("$has_telephone", hasTelephony.booleanValue());
                }
                if (null != (carrier = Worker.this.mSystemInformation.getCurrentNetworkOperator()) && !carrier.trim().isEmpty()) {
                    ret.put("$carrier", (Object)carrier);
                }
                if (null != (isWifi = Worker.this.mSystemInformation.isWifiConnected())) {
                    ret.put("$wifi", isWifi.booleanValue());
                }
                if ((isBluetoothEnabled = Worker.this.mSystemInformation.isBluetoothEnabled()) != null) {
                    ret.put("$bluetooth_enabled", (Object)isBluetoothEnabled);
                }
                if ((bluetoothVersion = Worker.this.mSystemInformation.getBluetoothVersion()) != null) {
                    ret.put("$bluetooth_version", (Object)bluetoothVersion);
                }
                return ret;
            }

            private JSONObject prepareEventObject(EventDescription eventDescription) throws JSONException {
                JSONObject eventObj = new JSONObject();
                JSONObject eventProperties = eventDescription.getProperties();
                JSONObject sendProperties = this.getDefaultEventProperties();
                sendProperties.put("token", (Object)eventDescription.getToken());
                if (eventProperties != null) {
                    Iterator iter = eventProperties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        sendProperties.put(key, eventProperties.get(key));
                    }
                }
                eventObj.put("event", (Object)eventDescription.getEventName());
                eventObj.put("properties", (Object)sendProperties);
                eventObj.put("$mp_metadata", (Object)eventDescription.getSessionMetadata());
                return eventObj;
            }
        }
    }

    static class MixpanelDescription {
        private final String mToken;

        public MixpanelDescription(String token) {
            this.mToken = token;
        }

        public String getToken() {
            return this.mToken;
        }
    }

    static class UpdateEventsPropertiesDescription
    extends MixpanelDescription {
        private final Map<String, String> mProps;

        public UpdateEventsPropertiesDescription(String token, Map<String, String> props) {
            super(token);
            this.mProps = props;
        }

        public Map<String, String> getProperties() {
            return this.mProps;
        }
    }

    static class MixpanelMessageDescription
    extends MixpanelDescription {
        private final JSONObject mMessage;

        public MixpanelMessageDescription(String token, JSONObject message) {
            super(token);
            if (message != null && message.length() > 0) {
                Iterator it = message.keys();
                while (it.hasNext()) {
                    String jsonKey = (String)it.next();
                    try {
                        message.get(jsonKey).toString();
                    }
                    catch (AssertionError e) {
                        message.remove(jsonKey);
                        MPLog.e(AnalyticsMessages.LOGTAG, "Removing people profile property from update (see https://github.com/mixpanel/mixpanel-android/issues/567)", (Throwable)((Object)e));
                    }
                    catch (JSONException jSONException) {}
                }
            }
            this.mMessage = message;
        }

        public JSONObject getMessage() {
            return this.mMessage;
        }
    }

    static class PushAnonymousPeopleDescription
    extends MixpanelDescription {
        private final String mDistinctId;

        public PushAnonymousPeopleDescription(String distinctId, String token) {
            super(token);
            this.mDistinctId = distinctId;
        }

        public String toString() {
            return this.mDistinctId;
        }

        public String getDistinctId() {
            return this.mDistinctId;
        }
    }

    static class GroupDescription
    extends MixpanelMessageDescription {
        public GroupDescription(JSONObject message, String token) {
            super(token, message);
        }

        public String toString() {
            return this.getMessage().toString();
        }
    }

    static class PeopleDescription
    extends MixpanelMessageDescription {
        public PeopleDescription(JSONObject message, String token) {
            super(token, message);
        }

        public String toString() {
            return this.getMessage().toString();
        }

        public boolean isAnonymous() {
            return !this.getMessage().has("$distinct_id");
        }
    }

    static class EventDescription
    extends MixpanelMessageDescription {
        private final String mEventName;
        private final JSONObject mSessionMetadata;
        private final boolean mIsAutomatic;

        public EventDescription(String eventName, JSONObject properties, String token) {
            this(eventName, properties, token, false, new JSONObject());
        }

        public EventDescription(String eventName, JSONObject properties, String token, boolean isAutomatic, JSONObject sessionMetada) {
            super(token, properties);
            this.mEventName = eventName;
            this.mIsAutomatic = isAutomatic;
            this.mSessionMetadata = sessionMetada;
        }

        public String getEventName() {
            return this.mEventName;
        }

        public JSONObject getProperties() {
            return this.getMessage();
        }

        public JSONObject getSessionMetadata() {
            return this.mSessionMetadata;
        }

        public boolean isAutomatic() {
            return this.mIsAutomatic;
        }
    }
}

