/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.MatchedOperator;
import com.mmnaseri.utils.spring.data.domain.Modifier;
import com.mmnaseri.utils.spring.data.domain.Operator;
import com.mmnaseri.utils.spring.data.domain.OperatorContext;
import com.mmnaseri.utils.spring.data.domain.Parameter;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.ImmutableMatchedOperator;
import com.mmnaseri.utils.spring.data.domain.impl.ImmutableParameter;
import com.mmnaseri.utils.spring.data.domain.impl.QueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.domain.impl.QueryModifiers;
import com.mmnaseri.utils.spring.data.error.QueryParserException;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.query.NullHandling;
import com.mmnaseri.utils.spring.data.query.Order;
import com.mmnaseri.utils.spring.data.query.PageParameterExtractor;
import com.mmnaseri.utils.spring.data.query.PropertyDescriptor;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.query.SortDirection;
import com.mmnaseri.utils.spring.data.query.SortParameterExtractor;
import com.mmnaseri.utils.spring.data.query.impl.DefaultQueryDescriptor;
import com.mmnaseri.utils.spring.data.query.impl.DirectSortParameterExtractor;
import com.mmnaseri.utils.spring.data.query.impl.ImmutableOrder;
import com.mmnaseri.utils.spring.data.query.impl.ImmutableSort;
import com.mmnaseri.utils.spring.data.query.impl.PageablePageParameterExtractor;
import com.mmnaseri.utils.spring.data.query.impl.PageableSortParameterExtractor;
import com.mmnaseri.utils.spring.data.query.impl.WrappedSortParameterExtractor;
import com.mmnaseri.utils.spring.data.string.DocumentReader;
import com.mmnaseri.utils.spring.data.string.impl.DefaultDocumentReader;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import com.mmnaseri.utils.spring.data.tools.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class MethodQueryDescriptionExtractor
implements QueryDescriptionExtractor<Method> {
    private static final String ALL_IGNORE_CASE_SUFFIX = "(AllIgnoreCase|AllIgnoresCase|AllIgnoringCase)$";
    private static final String IGNORE_CASE_SUFFIX = "(IgnoreCase|IgnoresCase|IgnoringCase)$";
    private static final String ASC_SUFFIX = "Asc";
    private static final String DESC_SUFFIX = "Desc";
    private static final String DEFAULT_OPERATOR_SUFFIX = "Is";
    private final OperatorContext operatorContext;

    public MethodQueryDescriptionExtractor(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }

    @Override
    public QueryDescriptor extract(RepositoryMetadata repositoryMetadata, RepositoryFactoryConfiguration configuration, Method method) {
        PageParameterExtractor pageExtractor;
        String methodName = method.getName();
        boolean allIgnoreCase = methodName.matches(".*(AllIgnoreCase|AllIgnoresCase|AllIgnoringCase)$");
        methodName = allIgnoreCase ? methodName.replaceFirst(ALL_IGNORE_CASE_SUFFIX, "") : methodName;
        DefaultDocumentReader reader = new DefaultDocumentReader(methodName);
        String function = this.parseFunctionName(method, reader);
        QueryModifiers queryModifiers = this.parseQueryModifiers(method, reader);
        SortParameterExtractor sortExtractor = null;
        ArrayList<List<Parameter>> branches = new ArrayList<List<Parameter>>();
        if (!reader.hasMore()) {
            pageExtractor = null;
            sortExtractor = null;
        } else {
            reader.expect("By");
            if (!reader.hasMore()) {
                throw new QueryParserException(method.getDeclaringClass(), "Query method name cannot end with `By`");
            }
            int index = this.parseExpression(repositoryMetadata, method, methodName, allIgnoreCase, reader, branches);
            com.mmnaseri.utils.spring.data.query.Sort sort = this.parseSort(repositoryMetadata, method, reader);
            pageExtractor = this.getPageParameterExtractor(method, index, sort);
            sortExtractor = this.getSortParameterExtractor(method, index, sort);
        }
        return new DefaultQueryDescriptor(queryModifiers.isDistinct(), function, queryModifiers.getLimit(), pageExtractor, sortExtractor, branches, configuration, repositoryMetadata);
    }

    private SortParameterExtractor getSortParameterExtractor(Method method, int index, com.mmnaseri.utils.spring.data.query.Sort sort) {
        SortParameterExtractor sortExtractor = null;
        if (method.getParameterTypes().length == index) {
            sortExtractor = sort == null ? null : new WrappedSortParameterExtractor(sort);
        } else if (method.getParameterTypes().length == index + 1) {
            if (Pageable.class.isAssignableFrom(method.getParameterTypes()[index])) {
                sortExtractor = sort == null ? new PageableSortParameterExtractor(index) : new WrappedSortParameterExtractor(sort);
            } else if (Sort.class.isAssignableFrom(method.getParameterTypes()[index])) {
                sortExtractor = new DirectSortParameterExtractor(index);
            }
        }
        return sortExtractor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PageParameterExtractor getPageParameterExtractor(Method method, int index, com.mmnaseri.utils.spring.data.query.Sort sort) {
        if (method.getParameterTypes().length == index) {
            return null;
        }
        if (method.getParameterTypes().length != index + 1) throw new QueryParserException(method.getDeclaringClass(), "Too many parameters declared for query method " + method);
        if (Pageable.class.isAssignableFrom(method.getParameterTypes()[index])) {
            return new PageablePageParameterExtractor(index);
        }
        if (!Sort.class.isAssignableFrom(method.getParameterTypes()[index])) throw new QueryParserException(method.getDeclaringClass(), "Invalid last argument: expected paging or sorting " + method);
        if (sort == null) return null;
        throw new QueryParserException(method.getDeclaringClass(), "You cannot specify both an order-by clause and a dynamic ordering");
    }

    private int parseExpression(RepositoryMetadata repositoryMetadata, Method method, String methodName, boolean allIgnoreCase, DocumentReader reader, List<List<Parameter>> branches) {
        int index = 0;
        branches.add(new LinkedList());
        while (reader.hasMore()) {
            String expression = this.parseInitialExpression(reader);
            boolean branchEnd = expression.endsWith("Or");
            boolean expressionEnd = expression.matches(".+[a-z]OrderBy[A-Z].+");
            expression = this.handleExpressionEnd(reader, expression, expressionEnd);
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            if ((expression = this.parseModifiers(allIgnoreCase, expression, modifiers)).matches(".*?(And|Or)$") && !reader.hasMore()) {
                throw new QueryParserException(method.getDeclaringClass(), "Expected more tokens to follow AND/OR operator");
            }
            expression = expression.replaceFirst("(And|Or)$", "");
            String foundProperty = null;
            Operator operator = this.parseOperator(expression);
            if (operator != null) {
                foundProperty = expression.substring(0, expression.length() - ((MatchedOperator)operator).getMatchedToken().length());
            }
            if (operator == null || foundProperty.isEmpty()) {
                foundProperty = expression;
                operator = this.operatorContext.getBySuffix(DEFAULT_OPERATOR_SUFFIX);
            }
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(repositoryMetadata, method, foundProperty);
            String property = propertyDescriptor.getPath();
            int[] indices = new int[operator.getOperands()];
            index = this.parseParameterIndices(method, methodName, index, operator, propertyDescriptor, indices);
            ImmutableParameter parameter = new ImmutableParameter(property, modifiers, indices, operator);
            List<Parameter> currentBranch = branches.get(branches.size() - 1);
            currentBranch.add(parameter);
            if (branchEnd) {
                branches.add(new LinkedList());
            }
            if (!expressionEnd) continue;
            break;
        }
        return index;
    }

    private com.mmnaseri.utils.spring.data.query.Sort parseSort(RepositoryMetadata repositoryMetadata, Method method, DocumentReader reader) {
        ImmutableSort sort;
        if (reader.read("OrderBy") != null) {
            ArrayList<Order> orders = new ArrayList<Order>();
            while (reader.hasMore()) {
                orders.add(this.parseOrder(method, reader, repositoryMetadata));
            }
            sort = new ImmutableSort(orders);
        } else {
            sort = null;
        }
        return sort;
    }

    private int parseParameterIndices(Method method, String methodName, int index, Operator operator, PropertyDescriptor propertyDescriptor, int[] indices) {
        int parameterIndex = index;
        for (int i = 0; i < operator.getOperands(); ++i) {
            if (parameterIndex >= method.getParameterTypes().length) {
                throw new QueryParserException(method.getDeclaringClass(), "Expected to see parameter with index " + parameterIndex);
            }
            if (!propertyDescriptor.getType().isAssignableFrom(method.getParameterTypes()[parameterIndex])) {
                throw new QueryParserException(method.getDeclaringClass(), "Expected parameter " + parameterIndex + " on method " + methodName + " to be a descendant of " + propertyDescriptor.getType());
            }
            indices[i] = parameterIndex++;
        }
        return parameterIndex;
    }

    private PropertyDescriptor getPropertyDescriptor(RepositoryMetadata repositoryMetadata, Method method, String property) {
        PropertyDescriptor propertyDescriptor;
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor(repositoryMetadata.getEntityType(), property);
        }
        catch (Exception e) {
            throw new QueryParserException(method.getDeclaringClass(), "Could not find property `" + StringUtils.uncapitalize(property) + "` on `" + repositoryMetadata.getEntityType() + "`", e);
        }
        return propertyDescriptor;
    }

    private Operator parseOperator(String expression) {
        Operator operator = null;
        for (int i = 1; i < expression.length(); ++i) {
            String suffix = expression.substring(i);
            operator = this.operatorContext.getBySuffix(suffix);
            if (operator == null) continue;
            operator = new ImmutableMatchedOperator(operator, suffix);
            break;
        }
        return operator;
    }

    private String parseModifiers(boolean allIgnoreCase, String originalExpression, Set<Modifier> modifiers) {
        String expression = originalExpression;
        if (expression.matches(".*(IgnoreCase|IgnoresCase|IgnoringCase)$")) {
            modifiers.add(Modifier.IGNORE_CASE);
            expression = expression.replaceFirst(IGNORE_CASE_SUFFIX, "");
        } else if (allIgnoreCase) {
            modifiers.add(Modifier.IGNORE_CASE);
        }
        return expression;
    }

    private String handleExpressionEnd(DocumentReader reader, String originalExpression, boolean expressionEnd) {
        String expression = originalExpression;
        if (expressionEnd) {
            int length = expression.length();
            expression = expression.replaceFirst("^(.+[a-z])OrderBy[A-Z].+$", "$1");
            reader.backtrack(length -= expression.length());
        }
        return expression;
    }

    private String parseInitialExpression(DocumentReader reader) {
        String expression = reader.expect("(.*?)(And[A-Z]|Or[A-Z]|$)");
        if (expression.matches(".*?(And|Or)[A-Z]")) {
            reader.backtrack(1);
            expression = expression.substring(0, expression.length() - 1);
        }
        return expression;
    }

    private Order parseOrder(Method method, DocumentReader reader, RepositoryMetadata repositoryMetadata) {
        PropertyDescriptor propertyDescriptor;
        SortDirection direction;
        String expression = reader.expect(".*?(Asc|Desc)");
        if (expression.endsWith(ASC_SUFFIX)) {
            direction = SortDirection.ASCENDING;
            expression = expression.substring(0, expression.length() - ASC_SUFFIX.length());
        } else {
            direction = SortDirection.DESCENDING;
            expression = expression.substring(0, expression.length() - DESC_SUFFIX.length());
        }
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor(repositoryMetadata.getEntityType(), expression);
        }
        catch (Exception e) {
            throw new QueryParserException(method.getDeclaringClass(), "Failed to get a property descriptor for expression: " + expression, e);
        }
        if (!Comparable.class.isAssignableFrom(propertyDescriptor.getType())) {
            throw new QueryParserException(method.getDeclaringClass(), "Sort property `" + propertyDescriptor.getPath() + "` is not comparable in `" + method.getName() + "`");
        }
        return new ImmutableOrder(direction, propertyDescriptor.getPath(), NullHandling.DEFAULT);
    }

    private String parseFunctionName(Method method, DocumentReader reader) {
        String function = reader.read(Pattern.compile("^[a-z]+"));
        if (function == null) {
            throw new QueryParserException(method.getDeclaringClass(), "Malformed query method name: " + method);
        }
        if (Arrays.asList("read", "find", "query", "get", "load", "select").contains(function)) {
            function = null;
        }
        return function;
    }

    private QueryModifiers parseQueryModifiers(Method method, DocumentReader reader) {
        int limit = 0;
        boolean distinct = false;
        while (reader.hasMore() && !reader.has("By")) {
            if (reader.has("First")) {
                if (limit > 0) {
                    throw new QueryParserException(method.getDeclaringClass(), "There is already a limit of " + limit + " specified for this query: " + method);
                }
                reader.expect("First");
                if (reader.has("\\d+")) {
                    limit = Integer.parseInt(reader.expect("\\d+"));
                    continue;
                }
                limit = 1;
                continue;
            }
            if (reader.has("Top")) {
                if (limit > 0) {
                    throw new QueryParserException(method.getDeclaringClass(), "There is already a limit of " + limit + " specified for this query: " + method);
                }
                reader.expect("Top");
                limit = Integer.parseInt(reader.expect("\\d+"));
                continue;
            }
            if (reader.has("Distinct")) {
                if (distinct) {
                    throw new QueryParserException(method.getDeclaringClass(), "You have already stated that this query should return distinct items: " + method);
                }
                distinct = true;
            }
            reader.expect("[A-Z][a-z]+");
        }
        return new QueryModifiers(limit, distinct);
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }
}

