/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl.id;

import com.mmnaseri.utils.spring.data.error.PropertyTypeMismatchException;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public final class IdPropertyResolverUtils {
    private static final List<String> ID_ANNOTATIONS = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(IdPropertyResolverUtils.class);

    private IdPropertyResolverUtils() {
        throw new UnsupportedOperationException();
    }

    public static String getPropertyNameFromAnnotatedMethod(Class<?> entityType, Class<? extends Serializable> idType, Method idAnnotatedMethod) {
        if (idAnnotatedMethod != null) {
            String name = PropertyUtils.getPropertyName(idAnnotatedMethod);
            if (!PropertyUtils.getTypeOf(idType).isAssignableFrom(PropertyUtils.getTypeOf(idAnnotatedMethod.getReturnType()))) {
                throw new PropertyTypeMismatchException(entityType, name, idType, idAnnotatedMethod.getReturnType());
            }
            return name;
        }
        return null;
    }

    public static boolean isAnnotated(AnnotatedElement element) {
        List<Class<? extends Annotation>> annotations = IdPropertyResolverUtils.getIdAnnotations();
        for (Class<? extends Annotation> annotation : annotations) {
            if (AnnotationUtils.findAnnotation((AnnotatedElement)element, annotation) == null) continue;
            return true;
        }
        return false;
    }

    private static List<Class<? extends Annotation>> getIdAnnotations() {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        for (String idAnnotation : ID_ANNOTATIONS) {
            try {
                Class type = ClassUtils.forName((String)idAnnotation, (ClassLoader)classLoader);
                Class<Annotation> annotationType = type.asSubclass(Annotation.class);
                annotations.add(annotationType);
            }
            catch (ClassNotFoundException ignored) {
                log.debug((Object)("Requested ID annotation type " + idAnnotation + " is not present in the classpath"));
            }
        }
        return annotations;
    }

    static {
        ID_ANNOTATIONS.add("org.springframework.data.annotation.Id");
        ID_ANNOTATIONS.add("javax.persistence.Id");
    }
}

