/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.dsl.mock;

import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.key.NoOpKeyGenerator;
import com.mmnaseri.utils.spring.data.dsl.factory.RepositoryFactoryBuilder;
import com.mmnaseri.utils.spring.data.dsl.mock.Implementation;
import com.mmnaseri.utils.spring.data.dsl.mock.ImplementationAnd;
import com.mmnaseri.utils.spring.data.dsl.mock.KeyGeneration;
import com.mmnaseri.utils.spring.data.dsl.mock.KeyGeneratorProvider;
import com.mmnaseri.utils.spring.data.dsl.mock.Start;
import com.mmnaseri.utils.spring.data.error.MockBuilderException;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactory;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.impl.DefaultRepositoryFactory;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class RepositoryMockBuilder
implements Start,
ImplementationAnd,
KeyGeneration {
    private final RepositoryFactory factory;
    private final List<Class<?>> implementations;
    private final KeyGenerator<? extends Serializable> keyGenerator;

    public RepositoryMockBuilder() {
        this(null, new LinkedList(), null);
    }

    private RepositoryMockBuilder(RepositoryFactory factory, List<Class<?>> implementations, KeyGenerator<? extends Serializable> keyGenerator) {
        this.factory = factory;
        this.implementations = implementations;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public KeyGeneration useConfiguration(RepositoryFactoryConfiguration configuration) {
        return new RepositoryMockBuilder(new DefaultRepositoryFactory(configuration), this.implementations, this.keyGenerator);
    }

    @Override
    public KeyGeneration useFactory(RepositoryFactory factory) {
        return new RepositoryMockBuilder(factory, this.implementations, this.keyGenerator);
    }

    @Override
    public ImplementationAnd usingImplementation(Class<?> implementation) {
        LinkedList implementations = new LinkedList(this.implementations);
        implementations.add(implementation);
        return new RepositoryMockBuilder(this.factory, implementations, this.keyGenerator);
    }

    @Override
    public ImplementationAnd and(Class<?> implementation) {
        return this.usingImplementation(implementation);
    }

    @Override
    public <S extends Serializable> Implementation generateKeysUsing(KeyGenerator<S> keyGenerator) {
        return new RepositoryMockBuilder(this.factory, this.implementations, keyGenerator);
    }

    @Override
    public <S extends Serializable, G extends KeyGenerator<S>> Implementation generateKeysUsing(Class<G> generatorType) {
        KeyGenerator<?> instance = this.createKeyGenerator(generatorType);
        return this.generateKeysUsing(instance);
    }

    @Override
    public Implementation withoutGeneratingKeys() {
        return new RepositoryMockBuilder(this.factory, this.implementations, new NoOpKeyGenerator());
    }

    private KeyGenerator<?> createKeyGenerator(Class<? extends KeyGenerator> generatorType) {
        KeyGenerator instance;
        try {
            instance = generatorType.newInstance();
        }
        catch (Exception e) {
            throw new MockBuilderException("Failed to instantiate key generator of type " + generatorType, e);
        }
        return instance;
    }

    @Override
    public <E> E mock(Class<E> repositoryInterface) {
        RepositoryFactory repositoryFactory = this.factory == null ? RepositoryFactoryBuilder.defaultFactory() : this.factory;
        if (this.keyGenerator == null) {
            KeyGenerator<?> evaluatedKeyGenerator;
            RepositoryFactoryConfiguration configuration = repositoryFactory.getConfiguration();
            if (configuration.getDefaultKeyGenerator() != null) {
                evaluatedKeyGenerator = configuration.getDefaultKeyGenerator();
            } else {
                KeyGeneratorProvider generatorProvider = new KeyGeneratorProvider();
                RepositoryMetadata metadata = configuration.getRepositoryMetadataResolver().resolve(repositoryInterface);
                Class<? extends Serializable> identifierType = metadata.getIdentifierType();
                Class<KeyGenerator<? extends Serializable>> keyGeneratorType = generatorProvider.getKeyGenerator(identifierType);
                evaluatedKeyGenerator = this.createKeyGenerator(keyGeneratorType);
            }
            return this.generateKeysUsing(evaluatedKeyGenerator).mock(repositoryInterface);
        }
        return repositoryFactory.getInstance(this.keyGenerator, repositoryInterface, this.implementations.toArray(new Class[this.implementations.size()]));
    }
}

