/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl;

import com.mmnaseri.utils.spring.data.domain.impl.ImmutableInvocation;
import com.mmnaseri.utils.spring.data.proxy.InvocationMapping;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.ResultAdapterContext;
import com.mmnaseri.utils.spring.data.proxy.ResultConverter;
import com.mmnaseri.utils.spring.data.proxy.impl.NonDataOperationInvocationHandler;
import com.mmnaseri.utils.spring.data.proxy.impl.converters.DefaultResultConverter;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataOperationInvocationHandler<K extends Serializable, E>
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(DataOperationInvocationHandler.class);
    private final DataStore<K, E> dataStore;
    private final ResultAdapterContext adapterContext;
    private final ResultConverter converter;
    private final RepositoryConfiguration repositoryConfiguration;
    private final List<InvocationMapping<K, E>> mappings;
    private final Map<Method, InvocationMapping<K, E>> cache = new ConcurrentHashMap<Method, InvocationMapping<K, E>>();
    private final Set<Method> misses = new CopyOnWriteArraySet<Method>();
    private final NonDataOperationInvocationHandler operationInvocationHandler;

    public DataOperationInvocationHandler(RepositoryConfiguration repositoryConfiguration, List<InvocationMapping<K, E>> mappings, DataStore<K, E> dataStore, ResultAdapterContext adapterContext, NonDataOperationInvocationHandler operationInvocationHandler) {
        this.repositoryConfiguration = repositoryConfiguration;
        this.mappings = mappings;
        this.dataStore = dataStore;
        this.adapterContext = adapterContext;
        this.operationInvocationHandler = operationInvocationHandler;
        this.converter = new DefaultResultConverter();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.info((Object)("A method call to " + method + " has been intercepted. We will now try to find an appropriate invocation."));
        ImmutableInvocation methodInvocation = new ImmutableInvocation(method, args);
        InvocationMapping<K, E> targetMapping = null;
        if (!this.misses.contains(method)) {
            if (this.cache.containsKey(method)) {
                targetMapping = this.cache.get(method);
            } else {
                for (InvocationMapping<K, E> mapping : this.mappings) {
                    if (!mapping.getMethod().equals(method)) continue;
                    targetMapping = mapping;
                    this.cache.put(method, targetMapping);
                    break;
                }
            }
        }
        if (targetMapping == null) {
            log.info((Object)"The invocation cannot be resolved using a data operation. We will try to handle this as a non-data operation");
            this.misses.add(method);
            return this.operationInvocationHandler.invoke(proxy, method, args);
        }
        DataStoreOperation<?, K, E> operation = targetMapping.getOperation();
        log.info((Object)("Executing the operation for method " + method));
        Object operationResult = operation.execute(this.dataStore, this.repositoryConfiguration, methodInvocation);
        log.info((Object)"Trying to see if any conversion is necessary on the object");
        Object convertedResult = this.converter.convert(methodInvocation, operationResult);
        return this.adapterContext.adapt(methodInvocation, convertedResult);
    }
}

