/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl;

import com.mmnaseri.utils.spring.data.domain.DataStoreAware;
import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.KeyGeneratorAware;
import com.mmnaseri.utils.spring.data.domain.RepositoryAware;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataAware;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.MethodQueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.domain.impl.key.NoOpKeyGenerator;
import com.mmnaseri.utils.spring.data.proxy.DataOperationResolver;
import com.mmnaseri.utils.spring.data.proxy.InvocationMapping;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfigurationAware;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactory;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryAware;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfigurationAware;
import com.mmnaseri.utils.spring.data.proxy.ResultAdapterContext;
import com.mmnaseri.utils.spring.data.proxy.TypeMapping;
import com.mmnaseri.utils.spring.data.proxy.TypeMappingContext;
import com.mmnaseri.utils.spring.data.proxy.impl.DataOperationInvocationHandler;
import com.mmnaseri.utils.spring.data.proxy.impl.DefaultTypeMappingContext;
import com.mmnaseri.utils.spring.data.proxy.impl.ImmutableInvocationMapping;
import com.mmnaseri.utils.spring.data.proxy.impl.ImmutableRepositoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.impl.NonDataOperationInvocationHandler;
import com.mmnaseri.utils.spring.data.proxy.impl.resolvers.DefaultDataOperationResolver;
import com.mmnaseri.utils.spring.data.query.DataFunctionRegistry;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import com.mmnaseri.utils.spring.data.store.DataStoreRegistry;
import com.mmnaseri.utils.spring.data.store.impl.DefaultDataStoreEventListenerContext;
import com.mmnaseri.utils.spring.data.store.impl.EventPublishingDataStore;
import com.mmnaseri.utils.spring.data.store.impl.MemoryDataStore;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRepositoryFactory
implements RepositoryFactory {
    private static final Log log = LogFactory.getLog(DefaultRepositoryFactory.class);
    private final RepositoryMetadataResolver repositoryMetadataResolver;
    private final Map<Class<?>, RepositoryMetadata> metadataMap = new ConcurrentHashMap();
    private final MethodQueryDescriptionExtractor descriptionExtractor;
    private final DataFunctionRegistry functionRegistry;
    private final DataStoreRegistry dataStoreRegistry;
    private final ResultAdapterContext adapterContext;
    private final TypeMappingContext typeMappingContext;
    private final RepositoryFactoryConfiguration configuration;
    private final NonDataOperationInvocationHandler operationInvocationHandler;

    public DefaultRepositoryFactory(RepositoryFactoryConfiguration configuration) {
        this.configuration = configuration;
        this.repositoryMetadataResolver = configuration.getRepositoryMetadataResolver();
        this.descriptionExtractor = configuration.getDescriptionExtractor();
        this.functionRegistry = configuration.getFunctionRegistry();
        this.dataStoreRegistry = configuration.getDataStoreRegistry();
        this.adapterContext = configuration.getResultAdapterContext();
        this.typeMappingContext = configuration.getTypeMappingContext();
        this.operationInvocationHandler = configuration.getOperationInvocationHandler();
    }

    @Override
    public <E> E getInstance(KeyGenerator<? extends Serializable> keyGenerator, Class<E> repositoryInterface, Class ... implementations) {
        KeyGenerator<Object> actualKeyGenerator = keyGenerator == null ? (this.configuration.getDefaultKeyGenerator() != null ? this.configuration.getDefaultKeyGenerator() : new NoOpKeyGenerator<Serializable>()) : keyGenerator;
        log.info((Object)("We are going to create a proxy instance of type " + repositoryInterface + " using key generator " + actualKeyGenerator + " and binding the implementations to " + Arrays.toString(implementations)));
        log.info((Object)("Resolving repository metadata for " + repositoryInterface));
        RepositoryMetadata metadata = this.getRepositoryMetadata(repositoryInterface);
        log.info((Object)("Resolving the data store for " + repositoryInterface));
        DataStore<Serializable, Object> dataStore = this.getDataStore(metadata);
        log.info((Object)("Trying to find all the proper type mappings for entity repository " + repositoryInterface));
        List<TypeMapping<?>> typeMappings = this.getTypeMappings(metadata, dataStore, actualKeyGenerator, implementations);
        DefaultDataOperationResolver operationResolver = new DefaultDataOperationResolver(typeMappings, this.descriptionExtractor, metadata, this.functionRegistry, this.configuration);
        Method[] methods = repositoryInterface.getMethods();
        log.info((Object)("Trying to find all the invocation mappings for methods declared on " + repositoryInterface));
        List invocationMappings = this.getInvocationMappings(operationResolver, methods);
        LinkedList boundImplementations = new LinkedList();
        for (TypeMapping<?> mapping : typeMappings) {
            boundImplementations.add(mapping.getType());
        }
        ImmutableRepositoryConfiguration repositoryConfiguration = new ImmutableRepositoryConfiguration(metadata, actualKeyGenerator, boundImplementations);
        DataOperationInvocationHandler<Serializable, Object> interceptor = new DataOperationInvocationHandler<Serializable, Object>(repositoryConfiguration, invocationMappings, dataStore, this.adapterContext, this.operationInvocationHandler);
        log.info((Object)"Instantiating the proxy using the provided configuration");
        Object instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{repositoryInterface}, interceptor);
        for (TypeMapping<?> typeMapping : typeMappings) {
            log.info((Object)"Injecting all the required dependencies into the repository mapping implementations");
            if (typeMapping.getInstance() instanceof RepositoryAware) {
                ((RepositoryAware)typeMapping.getInstance()).setRepository(instance);
            }
            if (typeMapping.getInstance() instanceof RepositoryConfigurationAware) {
                ((RepositoryConfigurationAware)typeMapping.getInstance()).setRepositoryConfiguration(repositoryConfiguration);
            }
            if (!(typeMapping.getInstance() instanceof RepositoryFactoryAware)) continue;
            ((RepositoryFactoryAware)typeMapping.getInstance()).setRepositoryFactory(this);
        }
        return repositoryInterface.cast(instance);
    }

    @Override
    public RepositoryFactoryConfiguration getConfiguration() {
        return this.configuration;
    }

    private List<TypeMapping<?>> getTypeMappings(RepositoryMetadata metadata, DataStore<Serializable, Object> dataStore, KeyGenerator<? extends Serializable> keyGenerator, Class[] implementations) {
        LinkedList typeMappings = new LinkedList();
        DefaultTypeMappingContext localContext = new DefaultTypeMappingContext(this.typeMappingContext);
        for (Class implementation : implementations) {
            localContext.register(metadata.getRepositoryInterface(), implementation);
        }
        typeMappings.addAll(localContext.getMappings(metadata.getRepositoryInterface()));
        for (TypeMapping typeMapping : typeMappings) {
            if (typeMapping.getInstance() instanceof DataStoreAware) {
                DataStoreAware instance = (DataStoreAware)typeMapping.getInstance();
                instance.setDataStore(dataStore);
            }
            if (typeMapping.getInstance() instanceof RepositoryMetadataAware) {
                RepositoryMetadataAware instance = (RepositoryMetadataAware)typeMapping.getInstance();
                instance.setRepositoryMetadata(metadata);
            }
            if (typeMapping.getInstance() instanceof KeyGeneratorAware) {
                KeyGeneratorAware instance = (KeyGeneratorAware)typeMapping.getInstance();
                instance.setKeyGenerator(keyGenerator);
            }
            if (!(typeMapping.getInstance() instanceof RepositoryFactoryConfigurationAware)) continue;
            RepositoryFactoryConfigurationAware instance = (RepositoryFactoryConfigurationAware)typeMapping.getInstance();
            instance.setRepositoryFactoryConfiguration(this.configuration);
        }
        return typeMappings;
    }

    private <E> RepositoryMetadata getRepositoryMetadata(Class<E> repositoryInterface) {
        RepositoryMetadata metadata;
        if (this.metadataMap.containsKey(repositoryInterface)) {
            metadata = this.metadataMap.get(repositoryInterface);
        } else {
            metadata = this.repositoryMetadataResolver.resolve(repositoryInterface);
            this.metadataMap.put(repositoryInterface, metadata);
        }
        return metadata;
    }

    private DataStore<Serializable, Object> getDataStore(RepositoryMetadata metadata) {
        DataStore<Serializable, Object> dataStore = this.dataStoreRegistry.has(metadata.getEntityType()) ? this.dataStoreRegistry.getDataStore(metadata.getEntityType()) : new MemoryDataStore(metadata.getEntityType());
        if (!(dataStore instanceof EventPublishingDataStore)) {
            dataStore = new EventPublishingDataStore<Serializable, Object>(dataStore, metadata, new DefaultDataStoreEventListenerContext(this.configuration.getEventListenerContext()));
        }
        this.dataStoreRegistry.register(dataStore);
        return dataStore;
    }

    private List<InvocationMapping<? extends Serializable, ?>> getInvocationMappings(DataOperationResolver operationResolver, Method[] methods) {
        LinkedList invocationMappings = new LinkedList();
        for (Method method : methods) {
            DataStoreOperation<?, ?, ?> operation = operationResolver.resolve(method);
            invocationMappings.add(new ImmutableInvocationMapping(method, operation));
        }
        return invocationMappings;
    }
}

