/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.ResultAdapterFailureException;
import com.mmnaseri.utils.spring.data.proxy.ResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.ResultAdapterContext;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.CollectionIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.FutureIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.GeoPageIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.IteratorIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.ListenableFutureIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullSimpleResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullToCollectionResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullToFutureResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullToIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullToIteratorResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullToListenableFutureResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NullToSliceResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.NumberIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.PageIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.SameTypeResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.SimpleIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.SliceIterableResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.VoidResultAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultResultAdapterContext
implements ResultAdapterContext {
    private static final Log log = LogFactory.getLog(DefaultResultAdapterContext.class);
    private final List<ResultAdapter<?>> adapters = new ArrayList();

    public DefaultResultAdapterContext() {
        this(true);
    }

    public DefaultResultAdapterContext(boolean registerDefaults) {
        if (registerDefaults) {
            this.adapters.add(new VoidResultAdapter());
            this.adapters.add(new SameTypeResultAdapter());
            this.adapters.add(new NullSimpleResultAdapter());
            this.adapters.add(new NullToIteratorResultAdapter());
            this.adapters.add(new NullToCollectionResultAdapter());
            this.adapters.add(new NullToIterableResultAdapter());
            this.adapters.add(new NullToSliceResultAdapter());
            this.adapters.add(new NullToFutureResultAdapter());
            this.adapters.add(new NullToListenableFutureResultAdapter());
            this.adapters.add(new NumberIterableResultAdapter());
            this.adapters.add(new SimpleIterableResultAdapter());
            this.adapters.add(new IteratorIterableResultAdapter());
            this.adapters.add(new CollectionIterableResultAdapter());
            this.adapters.add(new SliceIterableResultAdapter());
            this.adapters.add(new PageIterableResultAdapter());
            this.adapters.add(new GeoPageIterableResultAdapter());
            this.adapters.add(new FutureIterableResultAdapter());
            this.adapters.add(new ListenableFutureIterableResultAdapter());
            Collections.sort(this.adapters);
        }
    }

    @Override
    public synchronized void register(ResultAdapter<?> adapter) {
        log.info((Object)("Registering adapter " + adapter + " with the registry"));
        this.adapters.add(adapter);
        Collections.sort(this.adapters);
    }

    @Override
    public Object adapt(Invocation invocation, Object originalResult) {
        log.info((Object)("Adapting the result of invocation to type " + invocation.getMethod().getReturnType()));
        for (ResultAdapter<?> adapter : this.adapters) {
            if (!adapter.accepts(invocation, originalResult)) continue;
            return adapter.adapt(invocation, originalResult);
        }
        log.error((Object)("Could not find any result adapter that was capable of adapting the result of the invocation to type " + invocation.getMethod().getReturnType()));
        throw new ResultAdapterFailureException(originalResult, invocation.getMethod().getReturnType());
    }

    @Override
    public Collection<ResultAdapter<?>> getAdapters() {
        return Collections.unmodifiableCollection(this.adapters);
    }
}

