/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl;

import com.mmnaseri.utils.spring.data.error.RepositoryDefinitionException;
import com.mmnaseri.utils.spring.data.proxy.TypeMapping;
import com.mmnaseri.utils.spring.data.proxy.TypeMappingContext;
import com.mmnaseri.utils.spring.data.proxy.impl.ImmutableTypeMapping;
import com.mmnaseri.utils.spring.data.repository.DefaultCrudRepository;
import com.mmnaseri.utils.spring.data.repository.DefaultGemfireRepository;
import com.mmnaseri.utils.spring.data.repository.DefaultJpaRepository;
import com.mmnaseri.utils.spring.data.repository.DefaultPagingAndSortingRepository;
import com.mmnaseri.utils.spring.data.repository.DefaultQueryByExampleExecutor;
import com.mmnaseri.utils.spring.data.repository.DefaultQueryDslPredicateExecutor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;

public class DefaultTypeMappingContext
implements TypeMappingContext {
    private static final Log log = LogFactory.getLog(DefaultTypeMappingContext.class);
    private static final String GEMFIRE_SUPPORT_CLASS = "org.springframework.data.gemfire.repository.GemfireRepository";
    private static final String JPA_SUPPORT_CLASS = "org.springframework.data.jpa.repository.JpaRepository";
    private static final String QUERYDSL_SUPPORT_CLASS = "org.springframework.data.querydsl.QueryDslPredicateExecutor";
    private static final String QUERY_BY_EXAMPLE_SUPPORT_CLASS = "org.springframework.data.repository.query.QueryByExampleExecutor";
    private static final String CGLIB_SUPPORT_CLASS = "net.sf.cglib.proxy.Callback";
    private final TypeMappingContext parent;
    private ConcurrentMap<Class<?>, List<Class<?>>> mappings = new ConcurrentHashMap();

    public DefaultTypeMappingContext() {
        this(true);
    }

    public DefaultTypeMappingContext(boolean registerDefaults) {
        this(null);
        if (registerDefaults) {
            log.info((Object)"Trying to register all the default type mappings");
            if (this.isClassPresent(GEMFIRE_SUPPORT_CLASS)) {
                log.debug((Object)"We seem to have Gemfire in the classpath, so, we should register the supporting registry");
                this.register(Object.class, DefaultGemfireRepository.class);
            }
            if (this.isClassPresent(JPA_SUPPORT_CLASS)) {
                log.debug((Object)"JPA support is enabled in this project, so we need to support the methods");
                this.register(Object.class, DefaultJpaRepository.class);
            }
            if (this.isClassPresent(QUERYDSL_SUPPORT_CLASS) && this.isClassPresent(CGLIB_SUPPORT_CLASS)) {
                log.debug((Object)"QueryDSL support is enabled. We will add the proper method implementations.");
                this.register(Object.class, DefaultQueryDslPredicateExecutor.class);
            }
            if (this.isClassPresent(QUERY_BY_EXAMPLE_SUPPORT_CLASS)) {
                log.debug((Object)"Query by example is enabled. We will the proper method implementations.");
                this.register(Object.class, DefaultQueryByExampleExecutor.class);
            }
            this.register(Object.class, DefaultPagingAndSortingRepository.class);
            this.register(Object.class, DefaultCrudRepository.class);
        }
    }

    private boolean isClassPresent(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
    }

    public DefaultTypeMappingContext(TypeMappingContext parent) {
        this.parent = parent;
    }

    @Override
    public void register(Class<?> repositoryType, Class<?> implementation) {
        if (Modifier.isAbstract(implementation.getModifiers()) || Modifier.isInterface(implementation.getModifiers())) {
            log.error((Object)"Cannot bind a non-concrete class as an implementation for a non-concrete class");
            throw new RepositoryDefinitionException(repositoryType, "Cannot bind a non-concrete class as an implementation for a non-concrete class");
        }
        log.info((Object)("Registering implementation " + implementation + " to super type " + repositoryType + "; this means any repository of this type will inherit functionality defined in the " + "bound implementation class."));
        this.mappings.putIfAbsent(repositoryType, new LinkedList());
        ((List)this.mappings.get(repositoryType)).add(implementation);
    }

    @Override
    public List<Class<?>> getImplementations(Class<?> repositoryType) {
        LinkedList classes = new LinkedList();
        for (Class repositorySuperType : this.mappings.keySet()) {
            if (!repositorySuperType.isAssignableFrom(repositoryType)) continue;
            classes.addAll((Collection)this.mappings.get(repositorySuperType));
        }
        Collections.sort(classes, AnnotationAwareOrderComparator.INSTANCE);
        if (this.parent != null) {
            classes.addAll(this.parent.getImplementations(repositoryType));
        }
        return classes;
    }

    @Override
    public List<TypeMapping<?>> getMappings(Class<?> repositoryType) {
        LinkedList typeMappings = new LinkedList();
        List<Class<?>> implementations = this.getImplementations(repositoryType);
        log.info((Object)("The repository " + repositoryType + " is bound to implementations " + implementations));
        for (Class<?> implementation : implementations) {
            Object instance;
            try {
                instance = implementation.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Failed to instantiate class " + implementation + " because there was an error in the constructor"));
                throw new RepositoryDefinitionException(repositoryType, "Failed to instantiate an object of type " + implementation, e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("The constructor for the implementation class is not accessible: " + implementation));
                throw new RepositoryDefinitionException(repositoryType, "Failed to access the constructor for " + implementation, e);
            }
            catch (Exception e) {
                log.error((Object)("The constructor for " + implementation + " threw an exception"));
                throw new RepositoryDefinitionException(repositoryType, "Constructor threw an exception " + implementation, e);
            }
            typeMappings.add(new ImmutableTypeMapping(implementation, instance));
        }
        return typeMappings;
    }
}

