/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.adapters;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.ResultAdapterFailureException;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.AbstractIterableResultAdapter;
import com.mmnaseri.utils.spring.data.tools.CollectionInstanceUtils;
import java.util.Collection;

public class CollectionIterableResultAdapter
extends AbstractIterableResultAdapter<Collection> {
    public CollectionIterableResultAdapter() {
        super(-300);
    }

    @Override
    protected Collection doAdapt(Invocation invocation, Iterable iterable) {
        Collection<?> collection;
        try {
            collection = CollectionInstanceUtils.getCollection(invocation.getMethod().getReturnType());
        }
        catch (IllegalArgumentException e) {
            throw new ResultAdapterFailureException((Object)iterable, invocation.getMethod().getReturnType(), e);
        }
        for (Object item : iterable) {
            collection.add(item);
        }
        return collection;
    }

    @Override
    public boolean accepts(Invocation invocation, Object originalValue) {
        return originalValue != null && originalValue instanceof Iterable && Collection.class.isAssignableFrom(invocation.getMethod().getReturnType());
    }
}

