/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.adapters;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.ResultAdapterFailureException;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.AbstractIterableResultAdapter;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.util.Iterator;

public class NumberIterableResultAdapter
extends AbstractIterableResultAdapter<Object> {
    public NumberIterableResultAdapter() {
        super(-425);
    }

    @Override
    protected Object doAdapt(Invocation invocation, Iterable iterable) {
        Iterator iterator = iterable.iterator();
        Object value = iterator.next();
        Number number = (Number)value;
        Class<?> returnType = PropertyUtils.getTypeOf(invocation.getMethod().getReturnType());
        if (Long.class.equals(returnType)) {
            return number.longValue();
        }
        if (Short.class.equals(returnType)) {
            return number.shortValue();
        }
        if (Integer.class.equals(returnType)) {
            return number.intValue();
        }
        if (Byte.class.equals(returnType)) {
            return number.byteValue();
        }
        if (Double.class.equals(returnType)) {
            return number.doubleValue();
        }
        if (Float.class.equals(returnType)) {
            return Float.valueOf(number.floatValue());
        }
        throw new ResultAdapterFailureException(value, returnType);
    }

    @Override
    public boolean accepts(Invocation invocation, Object originalValue) {
        Iterable iterable;
        Iterator iterator;
        if (originalValue == null) {
            return false;
        }
        if (!Number.class.isAssignableFrom(PropertyUtils.getTypeOf(invocation.getMethod().getReturnType()))) {
            return false;
        }
        if (originalValue instanceof Iterable && (iterator = (iterable = (Iterable)originalValue).iterator()).hasNext()) {
            Object value = iterator.next();
            return value instanceof Number && !iterator.hasNext();
        }
        return false;
    }
}

