/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.resolvers;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.MethodQueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.error.DataOperationDefinitionException;
import com.mmnaseri.utils.spring.data.error.UnknownDataOperationException;
import com.mmnaseri.utils.spring.data.proxy.DataOperationResolver;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.TypeMapping;
import com.mmnaseri.utils.spring.data.proxy.impl.resolvers.QueryMethodDataOperationResolver;
import com.mmnaseri.utils.spring.data.proxy.impl.resolvers.SignatureDataOperationResolver;
import com.mmnaseri.utils.spring.data.query.DataFunctionRegistry;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDataOperationResolver
implements DataOperationResolver {
    private static final Log log = LogFactory.getLog(DefaultDataOperationResolver.class);
    private final List<DataOperationResolver> resolvers = new ArrayList<DataOperationResolver>();

    public DefaultDataOperationResolver(List<TypeMapping<?>> implementations, MethodQueryDescriptionExtractor descriptionExtractor, RepositoryMetadata repositoryMetadata, DataFunctionRegistry functionRegistry, RepositoryFactoryConfiguration configuration) {
        this.resolvers.add(new SignatureDataOperationResolver(implementations));
        this.resolvers.add(new QueryMethodDataOperationResolver(descriptionExtractor, repositoryMetadata, functionRegistry, configuration));
    }

    @Override
    public DataStoreOperation<?, ?, ?> resolve(Method method) {
        log.info((Object)("Resolving the data operation for method " + method));
        for (DataOperationResolver resolver : this.resolvers) {
            DataStoreOperation<?, ?, ?> resolution;
            log.debug((Object)("Attempting to resolve the method call using resolver " + resolver));
            try {
                resolution = resolver.resolve(method);
            }
            catch (Exception e) {
                throw new DataOperationDefinitionException(method, (Throwable)e);
            }
            if (resolution == null) continue;
            return resolution;
        }
        log.error((Object)("No suitable data operation could be found for method " + method));
        throw new UnknownDataOperationException(method);
    }
}

