/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.query.impl;

import com.mmnaseri.utils.spring.data.error.DataFunctionException;
import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.query.DataFunction;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteDataFunction
implements DataFunction<List<?>> {
    private static final Log log = LogFactory.getLog(DeleteDataFunction.class);

    @Override
    public <K extends Serializable, E> List<E> apply(DataStore<K, E> dataStore, QueryDescriptor query, RepositoryConfiguration repositoryConfiguration, List<E> selection) {
        if (dataStore == null) {
            log.error((Object)"Cannot delete entities when the data store is null");
            throw new InvalidArgumentException("Data store cannot be null");
        }
        if (query == null) {
            log.error((Object)"Cannot delete entities when the query is null");
            throw new InvalidArgumentException("Query cannot be null");
        }
        if (selection == null) {
            log.error((Object)"Cannot delete entities when the selection is null");
            throw new InvalidArgumentException("Selection cannot be null");
        }
        String identifier = query.getRepositoryMetadata().getIdentifierProperty();
        log.info((Object)("Using property " + identifier + " to delete the entities"));
        LinkedList<E> deleted = new LinkedList<E>();
        for (E item : selection) {
            Object key;
            try {
                key = PropertyUtils.getPropertyValue(item, identifier);
            }
            catch (Exception e) {
                log.error((Object)("The value of property " + identifier + " could not be read "));
                throw new DataFunctionException("Failed to read property value for property " + identifier, e);
            }
            if (key == null) {
                log.error((Object)"Cannot delete an entity when the identifier property has been set to null");
                throw new DataFunctionException("Cannot delete an entity without the key property being set: " + identifier);
            }
            if (!dataStore.delete((Serializable)key)) continue;
            deleted.add(item);
        }
        log.error((Object)("Deleted " + deleted.size() + " entities as the result of the delete call"));
        return deleted;
    }
}

