/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.query.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.query.Page;
import com.mmnaseri.utils.spring.data.query.PageParameterExtractor;
import com.mmnaseri.utils.spring.data.query.impl.ImmutablePage;
import org.springframework.data.domain.Pageable;

public class PageablePageParameterExtractor
implements PageParameterExtractor {
    private final int index;

    public PageablePageParameterExtractor(int index) {
        this.index = index;
    }

    @Override
    public Page extract(Invocation invocation) {
        if (invocation == null) {
            throw new InvalidArgumentException("Invocation cannot be null");
        }
        Object value = invocation.getArguments()[this.index];
        if (value == null) {
            throw new InvalidArgumentException("Page value should not be empty");
        }
        if (value instanceof Pageable) {
            Pageable pageable = (Pageable)value;
            return new ImmutablePage(pageable.getPageSize(), pageable.getPageNumber());
        }
        throw new InvalidArgumentException("No valid value was passed to deduce the paging description from");
    }
}

