/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.DataStoreAware;
import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.KeyGeneratorAware;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataAware;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrudRepositorySupport
implements DataStoreAware,
RepositoryMetadataAware,
KeyGeneratorAware<Serializable> {
    private static final Log log = LogFactory.getLog(CrudRepositorySupport.class);
    private KeyGenerator<? extends Serializable> keyGenerator;
    private DataStore dataStore;
    private RepositoryMetadata repositoryMetadata;

    protected CrudRepositorySupport() {
    }

    public Object save(Object entity) {
        Object key = PropertyUtils.getPropertyValue(entity, this.repositoryMetadata.getIdentifierProperty());
        log.info((Object)("The entity that is to be saved has a key with value " + key));
        if (key == null && this.keyGenerator != null) {
            log.info((Object)"The key was null, but the generator was not, so we are going to get a key for the entity");
            key = this.keyGenerator.generate();
            log.debug((Object)("The generated key for the entity was " + key));
            PropertyUtils.setPropertyValue(entity, this.repositoryMetadata.getIdentifierProperty(), key);
        }
        if (key == null) {
            log.warn((Object)"Attempting to save an entity without a key. This might result in an error. To fix this, specify a key generator.");
        }
        this.dataStore.save((Serializable)key, entity);
        return entity;
    }

    public final void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public final void setKeyGenerator(KeyGenerator<? extends Serializable> keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    @Override
    public final void setRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
    }

    protected KeyGenerator<? extends Serializable> getKeyGenerator() {
        return this.keyGenerator;
    }

    protected DataStore getDataStore() {
        return this.dataStore;
    }

    protected RepositoryMetadata getRepositoryMetadata() {
        return this.repositoryMetadata;
    }
}

