/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.error.EntityMissingKeyException;
import com.mmnaseri.utils.spring.data.repository.CrudRepositorySupport;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCrudRepository
extends CrudRepositorySupport {
    private static final Log log = LogFactory.getLog(DefaultCrudRepository.class);

    public Iterable<Object> save(Iterable entities) {
        LinkedList<Object> list = new LinkedList<Object>();
        log.info((Object)"Going to save a number of entities in the underlying data store");
        log.debug((Object)entities);
        for (Object entity : entities) {
            list.add(this.save(entity));
        }
        return list;
    }

    public Object findOne(Serializable key) {
        log.info((Object)("Attempting to load the entity with key " + key));
        return this.getDataStore().retrieve(key);
    }

    public boolean exists(Serializable key) {
        return this.getDataStore().hasKey(key);
    }

    public Iterable findAll(Iterable ids) {
        LinkedList<Object> entities = new LinkedList<Object>();
        log.info((Object)"Looking for multiple entities for a number of ids");
        log.debug((Object)ids);
        for (Object id : ids) {
            Object found = this.findOne((Serializable)id);
            if (found == null) continue;
            log.trace((Object)("Entity found for key " + id + ", adding the found entity to the list of returned entity"));
            entities.add(found);
        }
        return entities;
    }

    public Object delete(Serializable id) {
        Object retrieved = this.getDataStore().retrieve(id);
        this.getDataStore().delete(id);
        return retrieved;
    }

    public Object delete(Object entity) {
        Object key = PropertyUtils.getPropertyValue(entity, this.getRepositoryMetadata().getIdentifierProperty());
        if (key == null) {
            log.error((Object)"The entity that was supposed to be deleted, does not have a key");
            throw new EntityMissingKeyException(this.getRepositoryMetadata().getEntityType(), this.getRepositoryMetadata().getIdentifierProperty());
        }
        return this.delete((Serializable)key);
    }

    public Iterable delete(Iterable entities) {
        log.info((Object)"Attempting to delete multiple entities via entity objects themselves");
        log.debug((Object)entities);
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object entity : entities) {
            Object deleted = this.delete(entity);
            if (deleted == null) continue;
            log.debug((Object)"The entity was deleted successfully and will be added to the list of deleted entities");
            list.add(deleted);
        }
        return list;
    }

    public Iterable deleteAll() {
        log.info((Object)"Attempting to delete all entities at once");
        LinkedList<Object> list = new LinkedList<Object>();
        Collection keys = this.getDataStore().keys();
        log.debug((Object)("There are " + keys.size() + " entities altogether in the data store that are going to be deleted"));
        for (Object key : keys) {
            Object deleted = this.delete((Serializable)key);
            if (deleted == null) continue;
            log.debug((Object)"The entity was deleted successfully and will be added to the list of deleted entities");
            list.add(deleted);
        }
        Collection remainingKeys = this.getDataStore().keys();
        log.debug((Object)("There are " + remainingKeys.size() + " keys remaining in the data store after the delete operation"));
        return list;
    }
}

