/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.error.EntityMissingKeyException;
import com.mmnaseri.utils.spring.data.repository.CrudRepositorySupport;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.QueueingDataStore;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJpaRepository
extends CrudRepositorySupport {
    private static final Log log = LogFactory.getLog(DefaultJpaRepository.class);

    public void flush() {
        DataStore dataStore = this.getDataStore();
        if (dataStore instanceof QueueingDataStore) {
            log.info((Object)"Asking the data store to flush the underlying operation queue");
            QueueingDataStore store = (QueueingDataStore)dataStore;
            store.flush();
        }
    }

    public Iterable deleteInBatch(Iterable entities) {
        LinkedList<Serializable> keys = new LinkedList<Serializable>();
        for (Object entity : entities) {
            Object key = PropertyUtils.getPropertyValue(entity, this.getRepositoryMetadata().getIdentifierProperty());
            if (key == null) {
                log.error((Object)"There is no key set for the entity we were trying to delete");
                throw new EntityMissingKeyException(this.getRepositoryMetadata().getEntityType(), this.getRepositoryMetadata().getIdentifierProperty());
            }
            Serializable serializable = (Serializable)key;
            keys.add(serializable);
        }
        return this.deleteByKeysInBatch(keys);
    }

    public Iterable deleteAllInBatch() {
        log.info((Object)"Attempting to delete all the entities in the data store in a batch");
        return this.deleteByKeysInBatch(this.getDataStore().keys());
    }

    private Iterable deleteByKeysInBatch(Collection<Serializable> keys) {
        Object batch;
        if (this.getDataStore() instanceof QueueingDataStore) {
            log.debug((Object)"The data store support queueing, so we are going to start a batch");
            batch = ((QueueingDataStore)this.getDataStore()).startBatch();
        } else {
            log.debug((Object)"The data store does not support batching, so this is the same as a normal delete");
            batch = null;
        }
        LinkedList result = new LinkedList();
        for (Serializable key : keys) {
            if (!this.getDataStore().hasKey(key)) continue;
            result.add(this.getDataStore().retrieve(key));
            this.getDataStore().delete(key);
        }
        if (this.getDataStore() instanceof QueueingDataStore) {
            log.debug((Object)"Ending the batch operation that was started previously.");
            ((QueueingDataStore)this.getDataStore()).endBatch(batch);
        }
        return result;
    }

    public Object getOne(Serializable key) {
        if (this.getDataStore().hasKey(key)) {
            log.info((Object)("Returning entity for key " + key));
            return this.getDataStore().retrieve(key);
        }
        log.info((Object)("No entity was found with key " + key));
        return null;
    }

    public Object saveAndFlush(Object entity) {
        log.info((Object)("Saving entity " + entity + " to the data store."));
        Object saved = this.save(entity);
        log.info((Object)"Going to flush the data store after the save");
        this.flush();
        return saved;
    }
}

