/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.DataStoreAware;
import com.mmnaseri.utils.spring.data.repository.PagingAndSortingSupport;
import com.mmnaseri.utils.spring.data.repository.PagingAndSortingUtils;
import com.mmnaseri.utils.spring.data.store.DataStore;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class DefaultPagingAndSortingRepository
extends PagingAndSortingSupport
implements DataStoreAware {
    private static final Log log = LogFactory.getLog(DefaultPagingAndSortingRepository.class);
    private DataStore dataStore;

    public List findAll(Sort sort) {
        return PagingAndSortingUtils.sort(this.retrieveAll(), sort);
    }

    public Page findAll(Pageable pageable) {
        return DefaultPagingAndSortingRepository.page(this.retrieveAll(), pageable);
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    private Collection retrieveAll() {
        log.info((Object)"Loading all the data in the data store");
        return this.dataStore.retrieveAll();
    }
}

