/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.error.DataStoreNotFoundException;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreRegistry;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDataStoreRegistry
implements DataStoreRegistry {
    private static final Log log = LogFactory.getLog(DefaultDataStoreRegistry.class);
    private final Map<Class<?>, DataStore<?, ?>> dataStores = new ConcurrentHashMap();

    @Override
    public <E, K extends Serializable> void register(DataStore<K, E> dataStore) {
        log.info((Object)("Registering a data store for type " + dataStore.getEntityType()));
        this.dataStores.put(dataStore.getEntityType(), dataStore);
    }

    @Override
    public <E, K extends Serializable> DataStore<K, E> getDataStore(Class<E> entityType) {
        if (!this.dataStores.containsKey(entityType)) {
            log.error((Object)("There is no data store registered for entity type " + entityType));
            log.debug((Object)("Registered data types are " + this.dataStores.keySet()));
            throw new DataStoreNotFoundException(entityType);
        }
        return this.dataStores.get(entityType);
    }

    @Override
    public boolean has(Class<?> entityType) {
        return this.dataStores.containsKey(entityType);
    }
}

