/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.domain.impl.SelectDataStoreOperation;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.query.DataFunction;
import com.mmnaseri.utils.spring.data.query.DataFunctionRegistry;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DescribedDataStoreOperation<K, E>
implements DataStoreOperation<Object, K, E> {
    private static final Log log = LogFactory.getLog(DescribedDataStoreOperation.class);
    private final SelectDataStoreOperation<K, E> selectOperation;
    private final DataFunctionRegistry functionRegistry;

    public DescribedDataStoreOperation(SelectDataStoreOperation<K, E> selectOperation, DataFunctionRegistry functionRegistry) {
        this.selectOperation = selectOperation;
        this.functionRegistry = functionRegistry;
    }

    @Override
    public Object execute(DataStore<K, E> store, RepositoryConfiguration configuration, Invocation invocation) {
        log.info((Object)"Trying to select the data from the data store");
        Object selection = this.selectOperation.execute((DataStore)store, configuration, invocation);
        QueryDescriptor descriptor = this.selectOperation.getDescriptor();
        if (descriptor.getFunction() == null) {
            log.info((Object)"No function was specified for the current selection");
            return selection;
        }
        log.info((Object)("Executing function " + descriptor.getFunction() + " on the selected items"));
        DataFunction<?> function = this.functionRegistry.getFunction(descriptor.getFunction());
        return function.apply(store, descriptor, configuration, selection);
    }

    public String toString() {
        return this.selectOperation.toString();
    }
}

