/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.Modifier;
import com.mmnaseri.utils.spring.data.domain.Operator;
import com.mmnaseri.utils.spring.data.domain.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ImmutableParameter
implements Parameter {
    private final String path;
    private final Set<Modifier> modifiers;
    private final int[] indices;
    private final Operator operator;

    public ImmutableParameter(String path, Set<Modifier> modifiers, int[] indices, Operator operator) {
        this.path = path;
        this.operator = operator;
        this.modifiers = modifiers == null ? Collections.emptySet() : new HashSet<Modifier>(modifiers);
        this.indices = indices;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    @Override
    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    public String toString() {
        return "(" + this.path + "," + this.operator + "," + Arrays.toString(this.indices) + "," + this.modifiers + ")";
    }
}

