/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.domain.impl.PropertyComparator;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.query.Page;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.query.Sort;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectDataStoreOperation<K, E>
implements DataStoreOperation<List<E>, K, E> {
    private static final Log log = LogFactory.getLog(SelectDataStoreOperation.class);
    private final QueryDescriptor descriptor;

    public SelectDataStoreOperation(QueryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public QueryDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public List<E> execute(DataStore<K, E> store, RepositoryConfiguration configuration, Invocation invocation) {
        log.info((Object)("Selecting the data according to the provided selection descriptor: " + this.descriptor));
        LinkedList selection = new LinkedList();
        LinkedList<E> all = new LinkedList<E>(store.retrieveAll());
        for (Object entity : all) {
            if (!this.descriptor.matches(entity, invocation)) continue;
            selection.add(entity);
        }
        log.info((Object)("Matched " + selection.size() + " items from the data store"));
        if (this.descriptor.isDistinct()) {
            HashSet distinctValues = new HashSet(selection);
            selection.clear();
            selection.addAll(distinctValues);
            log.info((Object)("After clearing up duplicates, " + selection.size() + " items remained"));
        }
        Sort sort = this.descriptor.getSort(invocation);
        Page page = this.descriptor.getPage(invocation);
        if (sort != null) {
            log.info((Object)"Sorting the selected items according to the provided ordering");
            PropertyComparator.sort(selection, sort);
        }
        if (page != null) {
            log.info((Object)"We need to paginate the selection to fit the selection criteria");
            int start = page.getPageSize() * page.getPageNumber();
            int finish = Math.min(start + page.getPageSize(), selection.size());
            if (start > selection.size()) {
                selection.clear();
            } else {
                ArrayList view = new ArrayList(selection.subList(start, finish));
                selection.clear();
                selection.addAll(view);
            }
        }
        if (this.descriptor.getLimit() > 0) {
            log.info((Object)("Going to limit the result to " + this.descriptor.getLimit() + " items"));
            ArrayList view = new ArrayList(selection.subList(0, Math.min(selection.size(), this.descriptor.getLimit())));
            selection.clear();
            selection.addAll(view);
        }
        return selection;
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

