/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl.id;

import com.mmnaseri.utils.spring.data.domain.IdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.IdPropertyResolverUtils;
import com.mmnaseri.utils.spring.data.error.MultipleIdPropertiesException;
import com.mmnaseri.utils.spring.data.tools.GetterMethodFilter;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.util.ReflectionUtils;

public class AnnotatedGetterIdPropertyResolver
implements IdPropertyResolver {
    @Override
    public String resolve(Class<?> entityType, Class<?> idType) {
        AtomicReference found = new AtomicReference();
        ReflectionUtils.doWithMethods(entityType, method -> {
            if (IdPropertyResolverUtils.isAnnotated(method)) {
                if (found.get() == null) {
                    found.set(method);
                } else {
                    throw new MultipleIdPropertiesException(entityType);
                }
            }
        }, (ReflectionUtils.MethodFilter)new GetterMethodFilter());
        Method idAnnotatedMethod = (Method)found.get();
        return IdPropertyResolverUtils.getPropertyNameFromAnnotatedMethod(entityType, idType, idAnnotatedMethod);
    }
}

