/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl.matchers;

import com.mmnaseri.utils.spring.data.domain.Parameter;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.AbstractSimpleMatcher;
import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractCollectionMatcher
extends AbstractSimpleMatcher {
    @Override
    protected final boolean matches(Parameter parameter, Object actual, Object property) {
        LinkedList<Object> collection;
        if (property == null) {
            throw new InvalidArgumentException("Comparison property cannot be null: " + parameter.getPath());
        }
        if (property.getClass().isArray()) {
            collection = new LinkedList<Object>();
            for (int i = 0; i < Array.getLength(property); ++i) {
                Object item = Array.get(property, i);
                collection.add(item);
            }
        } else if (property instanceof Iterator) {
            collection = new LinkedList();
            Iterator iterator = (Iterator)property;
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        } else if (property instanceof Iterable) {
            collection = new LinkedList();
            for (Object item : (Iterable)property) {
                collection.add(item);
            }
        } else {
            throw new InvalidArgumentException("Expected an array, an iterator, or an iterable object");
        }
        return this.matches(actual, collection);
    }

    protected abstract boolean matches(Object var1, Collection var2);

    @Override
    public boolean isApplicableTo(Class<?> parameterType, Class<?> ... propertiesTypes) {
        Class<?> propertyType = propertiesTypes[0];
        return Collection.class.isAssignableFrom(propertyType) || Iterator.class.isAssignableFrom(propertyType) || Iterable.class.isAssignableFrom(propertyType);
    }
}

