/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.dsl.factory;

import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.Operator;
import com.mmnaseri.utils.spring.data.domain.OperatorContext;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.DefaultOperatorContext;
import com.mmnaseri.utils.spring.data.domain.impl.DefaultRepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.MethodQueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.dsl.factory.DataFunctions;
import com.mmnaseri.utils.spring.data.dsl.factory.DataFunctionsAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.DataStores;
import com.mmnaseri.utils.spring.data.dsl.factory.DataStoresAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.End;
import com.mmnaseri.utils.spring.data.dsl.factory.EventListener;
import com.mmnaseri.utils.spring.data.dsl.factory.EventListenerAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.FallbackKeyGenerator;
import com.mmnaseri.utils.spring.data.dsl.factory.MappingContext;
import com.mmnaseri.utils.spring.data.dsl.factory.MappingContextAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.OperationHandlersAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.OperatorsAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.QueryDescriptionConfigurer;
import com.mmnaseri.utils.spring.data.dsl.factory.ResultAdapters;
import com.mmnaseri.utils.spring.data.dsl.factory.ResultAdaptersAnd;
import com.mmnaseri.utils.spring.data.dsl.factory.Start;
import com.mmnaseri.utils.spring.data.dsl.mock.Implementation;
import com.mmnaseri.utils.spring.data.dsl.mock.ImplementationAnd;
import com.mmnaseri.utils.spring.data.dsl.mock.RepositoryMockBuilder;
import com.mmnaseri.utils.spring.data.proxy.NonDataOperationHandler;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactory;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.ResultAdapter;
import com.mmnaseri.utils.spring.data.proxy.ResultAdapterContext;
import com.mmnaseri.utils.spring.data.proxy.TypeMappingContext;
import com.mmnaseri.utils.spring.data.proxy.impl.DefaultRepositoryFactory;
import com.mmnaseri.utils.spring.data.proxy.impl.DefaultResultAdapterContext;
import com.mmnaseri.utils.spring.data.proxy.impl.DefaultTypeMappingContext;
import com.mmnaseri.utils.spring.data.proxy.impl.ImmutableRepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.impl.NonDataOperationInvocationHandler;
import com.mmnaseri.utils.spring.data.query.DataFunction;
import com.mmnaseri.utils.spring.data.query.DataFunctionRegistry;
import com.mmnaseri.utils.spring.data.query.impl.DefaultDataFunctionRegistry;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreEvent;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListener;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListenerContext;
import com.mmnaseri.utils.spring.data.store.DataStoreRegistry;
import com.mmnaseri.utils.spring.data.store.impl.AuditDataEventListener;
import com.mmnaseri.utils.spring.data.store.impl.DefaultDataStoreEventListenerContext;
import com.mmnaseri.utils.spring.data.store.impl.DefaultDataStoreRegistry;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.data.domain.AuditorAware;

public class RepositoryFactoryBuilder
implements Start,
DataFunctionsAnd,
DataStoresAnd,
EventListenerAnd,
MappingContextAnd,
OperatorsAnd,
ResultAdaptersAnd,
OperationHandlersAnd {
    public static final String DEFAULT_USER = "User";
    private RepositoryMetadataResolver metadataResolver = new DefaultRepositoryMetadataResolver();
    private MethodQueryDescriptionExtractor queryDescriptionExtractor = new MethodQueryDescriptionExtractor(new DefaultOperatorContext());
    private DataFunctionRegistry functionRegistry = new DefaultDataFunctionRegistry();
    private DataStoreRegistry dataStoreRegistry = new DefaultDataStoreRegistry();
    private ResultAdapterContext resultAdapterContext = new DefaultResultAdapterContext();
    private TypeMappingContext typeMappingContext = new DefaultTypeMappingContext();
    private DataStoreEventListenerContext eventListenerContext = new DefaultDataStoreEventListenerContext();
    private NonDataOperationInvocationHandler operationInvocationHandler = new NonDataOperationInvocationHandler();
    private KeyGenerator<?> defaultKeyGenerator = null;

    private RepositoryFactoryBuilder() {
    }

    @Override
    public QueryDescriptionConfigurer resolveMetadataUsing(RepositoryMetadataResolver metadataResolver) {
        this.metadataResolver = metadataResolver;
        return this;
    }

    @Override
    public DataFunctions withOperators(OperatorContext context) {
        this.queryDescriptionExtractor = new MethodQueryDescriptionExtractor(context);
        return this;
    }

    @Override
    public OperatorsAnd registerOperator(Operator operator) {
        this.queryDescriptionExtractor.getOperatorContext().register(operator);
        return this;
    }

    @Override
    public DataFunctions extractQueriesUsing(MethodQueryDescriptionExtractor extractor) {
        this.queryDescriptionExtractor = extractor;
        return this;
    }

    @Override
    public DataStores withDataFunctions(DataFunctionRegistry registry) {
        this.functionRegistry = registry;
        return this;
    }

    @Override
    public <R> DataFunctionsAnd registerFunction(String name, DataFunction<R> function) {
        this.functionRegistry.register(name, function);
        return this;
    }

    @Override
    public ResultAdapters withDataStores(DataStoreRegistry registry) {
        this.dataStoreRegistry = registry;
        return this;
    }

    @Override
    public <E, K> DataStoresAnd registerDataStore(DataStore<K, E> dataStore) {
        this.dataStoreRegistry.register(dataStore);
        return this;
    }

    @Override
    public MappingContext withAdapters(ResultAdapterContext context) {
        this.resultAdapterContext = context;
        return this;
    }

    @Override
    public <E> ResultAdaptersAnd adaptResultsUsing(ResultAdapter<E> adapter) {
        this.resultAdapterContext.register(adapter);
        return this;
    }

    @Override
    public EventListener withMappings(TypeMappingContext context) {
        this.typeMappingContext = context;
        return this;
    }

    @Override
    public MappingContextAnd honoringImplementation(Class<?> superType, Class<?> implementation) {
        this.typeMappingContext.register(superType, implementation);
        return this;
    }

    @Override
    public FallbackKeyGenerator withOperationHandlers(NonDataOperationInvocationHandler invocationHandler) {
        this.operationInvocationHandler = invocationHandler;
        return this;
    }

    @Override
    public OperationHandlersAnd withOperationHandler(NonDataOperationHandler handler) {
        this.operationInvocationHandler.register(handler);
        return this;
    }

    @Override
    public End withListeners(DataStoreEventListenerContext context) {
        this.eventListenerContext = context;
        return this;
    }

    @Override
    public <E extends DataStoreEvent> EventListenerAnd withListener(DataStoreEventListener<E> listener) {
        this.eventListenerContext.register(listener);
        return this;
    }

    @Override
    public EventListener enableAuditing(AuditorAware auditorAware) {
        return (EventListener)((Object)this.and(new AuditDataEventListener(auditorAware)));
    }

    @Override
    public EventListener enableAuditing() {
        return this.enableAuditing(new DefaultAuditorAware());
    }

    @Override
    public <R> DataFunctionsAnd and(String name, DataFunction<R> function) {
        this.functionRegistry.register(name, function);
        return this;
    }

    @Override
    public <E, K> DataStoresAnd and(DataStore<K, E> dataStore) {
        this.dataStoreRegistry.register(dataStore);
        return this;
    }

    @Override
    public OperationHandlersAnd and(NonDataOperationHandler handler) {
        this.operationInvocationHandler.register(handler);
        return this;
    }

    @Override
    public EventListener withDefaultKeyGenerator(KeyGenerator<?> keyGenerator) {
        this.defaultKeyGenerator = keyGenerator;
        return this;
    }

    @Override
    public <E extends DataStoreEvent> EventListenerAnd and(DataStoreEventListener<E> listener) {
        this.eventListenerContext.register(listener);
        return this;
    }

    @Override
    public MappingContextAnd and(Class<?> superType, Class<?> implementation) {
        this.typeMappingContext.register(superType, implementation);
        return this;
    }

    @Override
    public OperatorsAnd and(Operator operator) {
        this.queryDescriptionExtractor.getOperatorContext().register(operator);
        return this;
    }

    @Override
    public <E> ResultAdaptersAnd and(ResultAdapter<E> adapter) {
        this.resultAdapterContext.register(adapter);
        return this;
    }

    @Override
    public RepositoryFactory build() {
        return new DefaultRepositoryFactory(this.configure());
    }

    @Override
    public RepositoryFactoryConfiguration configure() {
        return new ImmutableRepositoryFactoryConfiguration(this.metadataResolver, this.queryDescriptionExtractor, this.functionRegistry, this.dataStoreRegistry, this.resultAdapterContext, this.typeMappingContext, this.eventListenerContext, this.operationInvocationHandler, this.defaultKeyGenerator);
    }

    @Override
    public <S> Implementation generateKeysUsing(KeyGenerator<S> keyGenerator) {
        return new RepositoryMockBuilder().useFactory(this.build()).generateKeysUsing(keyGenerator);
    }

    @Override
    public <S, G extends KeyGenerator<S>> Implementation generateKeysUsing(Class<G> generatorType) {
        return new RepositoryMockBuilder().useFactory(this.build()).generateKeysUsing(generatorType);
    }

    @Override
    public Implementation withoutGeneratingKeys() {
        return new RepositoryMockBuilder().useFactory(this.build()).withoutGeneratingKeys();
    }

    @Override
    public ImplementationAnd usingImplementation(Class<?> implementation) {
        return new RepositoryMockBuilder().useFactory(this.build()).usingImplementation(implementation);
    }

    @Override
    public <E> E mock(Class<E> repositoryInterface) {
        return new RepositoryMockBuilder().useFactory(this.build()).mock(repositoryInterface);
    }

    public static RepositoryFactoryConfiguration defaultConfiguration() {
        RepositoryFactoryBuilder builder = (RepositoryFactoryBuilder)RepositoryFactoryBuilder.builder();
        return new ImmutableRepositoryFactoryConfiguration(builder.metadataResolver, builder.queryDescriptionExtractor, builder.functionRegistry, builder.dataStoreRegistry, builder.resultAdapterContext, builder.typeMappingContext, builder.eventListenerContext, builder.operationInvocationHandler, builder.defaultKeyGenerator);
    }

    public static Start builder() {
        return new RepositoryFactoryBuilder();
    }

    public static Start given(RepositoryFactoryConfiguration configuration) {
        RepositoryFactoryBuilder builder = new RepositoryFactoryBuilder();
        builder.metadataResolver = RepositoryFactoryBuilder.getOrDefault(configuration.getRepositoryMetadataResolver(), builder.metadataResolver);
        builder.queryDescriptionExtractor = RepositoryFactoryBuilder.getOrDefault(configuration.getDescriptionExtractor(), builder.queryDescriptionExtractor);
        builder.functionRegistry = RepositoryFactoryBuilder.getOrDefault(configuration.getFunctionRegistry(), builder.functionRegistry);
        builder.dataStoreRegistry = RepositoryFactoryBuilder.getOrDefault(configuration.getDataStoreRegistry(), builder.dataStoreRegistry);
        builder.resultAdapterContext = RepositoryFactoryBuilder.getOrDefault(configuration.getResultAdapterContext(), builder.resultAdapterContext);
        builder.typeMappingContext = RepositoryFactoryBuilder.getOrDefault(configuration.getTypeMappingContext(), builder.typeMappingContext);
        builder.eventListenerContext = RepositoryFactoryBuilder.getOrDefault(configuration.getEventListenerContext(), builder.eventListenerContext);
        builder.operationInvocationHandler = RepositoryFactoryBuilder.getOrDefault(configuration.getOperationInvocationHandler(), builder.operationInvocationHandler);
        builder.defaultKeyGenerator = RepositoryFactoryBuilder.getOrDefault(configuration.getDefaultKeyGenerator(), builder.defaultKeyGenerator);
        return builder;
    }

    private static <E> E getOrDefault(E value, E defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static RepositoryFactory defaultFactory() {
        return new DefaultRepositoryFactory(RepositoryFactoryBuilder.defaultConfiguration());
    }

    public static class DefaultAuditorAware
    implements AuditorAware<String> {
        @Nonnull
        public Optional<String> getCurrentAuditor() {
            return Optional.of(RepositoryFactoryBuilder.DEFAULT_USER);
        }
    }
}

