/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.regular;

import com.mmnaseri.utils.spring.data.proxy.NonDataOperationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EqualsNonDataOperationHandler
implements NonDataOperationHandler {
    private static final String EQUALS = "equals";

    @Override
    public boolean handles(Object proxy, Method method, Object ... args) {
        return Object.class.equals(method.getDeclaringClass()) && EQUALS.equals(method.getName());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) {
        Object that = args[0];
        if (that == null || !Proxy.isProxyClass(that.getClass())) {
            return false;
        }
        return EqualsNonDataOperationHandler.superInterfaces(proxy.getClass()).collect(Collectors.toSet()).equals(EqualsNonDataOperationHandler.superInterfaces(that.getClass()).collect(Collectors.toSet()));
    }

    static Stream<Class<?>> superInterfaces(Class<?> type) {
        return Stream.concat(Stream.of(type), Arrays.stream(type.getInterfaces()).flatMap(EqualsNonDataOperationHandler::superInterfaces)).filter(item -> Modifier.isInterface(item.getModifiers()));
    }
}

