/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.resolvers;

import com.mmnaseri.utils.spring.data.domain.impl.MethodInvocationDataStoreOperation;
import com.mmnaseri.utils.spring.data.proxy.DataOperationResolver;
import com.mmnaseri.utils.spring.data.proxy.TypeMapping;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureDataOperationResolver
implements DataOperationResolver {
    private static final Log log = LogFactory.getLog(SignatureDataOperationResolver.class);
    private final List<TypeMapping<?>> mappings;

    public SignatureDataOperationResolver(List<TypeMapping<?>> mappings) {
        this.mappings = mappings;
    }

    @Override
    public DataStoreOperation<?, ?, ?> resolve(Method method) {
        log.info((Object)("Trying to resolve the data operation for method " + method + " by going through the previously set up type mappings"));
        for (TypeMapping<?> mapping : this.mappings) {
            Class<?> type = mapping.getType();
            Method declaration = SignatureDataOperationResolver.findMethod(type, method.getName(), method.getParameterTypes());
            if (declaration == null) continue;
            log.info((Object)"Setting the resolution as a method invocation on the previously prepared type mapping");
            Object instance = mapping.getInstance();
            return new MethodInvocationDataStoreOperation(instance, declaration);
        }
        return null;
    }

    private static Method findMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        log.debug((Object)("Attempting to look for the actual declaration of the method named '" + name + "' with parameter types " + Arrays.toString(parameterTypes) + " on the child type " + type));
        for (Class<?> searchType = type; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            log.trace((Object)("Looking at type " + type + " for method " + name));
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!method.getName().equals(name) || parameterTypes.length != method.getParameterTypes().length) continue;
                boolean matches = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    if (PropertyUtils.getTypeOf(method.getParameterTypes()[i]).isAssignableFrom(PropertyUtils.getTypeOf(parameterType))) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return method;
            }
        }
        return null;
    }
}

