/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.query.impl;

import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.query.DataFunction;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.store.DataStore;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountDataFunction
implements DataFunction<Long> {
    private static final Log log = LogFactory.getLog(CountDataFunction.class);

    @Override
    public <K, E> Long apply(DataStore<K, E> dataStore, QueryDescriptor query, RepositoryConfiguration repositoryConfiguration, List<E> selection) {
        if (selection == null) {
            log.error((Object)"Cannot calculate the count if the selection is null");
            throw new InvalidArgumentException("Selection cannot be null");
        }
        return Integer.valueOf(selection.size()).longValue();
    }
}

