/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.query.impl;

import com.mmnaseri.utils.spring.data.error.DuplicateFunctionException;
import com.mmnaseri.utils.spring.data.error.FunctionNotFoundException;
import com.mmnaseri.utils.spring.data.query.DataFunction;
import com.mmnaseri.utils.spring.data.query.DataFunctionRegistry;
import com.mmnaseri.utils.spring.data.query.impl.CountDataFunction;
import com.mmnaseri.utils.spring.data.query.impl.DeleteDataFunction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDataFunctionRegistry
implements DataFunctionRegistry {
    private static final Log log = LogFactory.getLog(DefaultDataFunctionRegistry.class);
    private final Map<String, DataFunction<?>> functions = new ConcurrentHashMap();

    public DefaultDataFunctionRegistry() {
        this(true);
    }

    public DefaultDataFunctionRegistry(boolean registerDefaults) {
        if (registerDefaults) {
            log.info((Object)"Registering the default functions");
            this.register("count", new CountDataFunction());
            this.register("delete", new DeleteDataFunction());
        }
    }

    @Override
    public void register(String name, DataFunction<?> function) {
        if (this.functions.containsKey(name)) {
            log.error((Object)("Cannot register a function with name " + name + " because that name is already taken"));
            throw new DuplicateFunctionException(name);
        }
        log.info((Object)("Registering function with name " + name));
        this.functions.put(name, function);
    }

    @Override
    public DataFunction<?> getFunction(String name) {
        if (!this.functions.containsKey(name)) {
            log.error((Object)("No function could be found with name " + name));
            throw new FunctionNotFoundException(name);
        }
        return this.functions.get(name);
    }

    @Override
    public Set<String> getFunctions() {
        return this.functions.keySet();
    }
}

