/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.query.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.domain.InvocationMatcher;
import com.mmnaseri.utils.spring.data.domain.Modifier;
import com.mmnaseri.utils.spring.data.domain.Operator;
import com.mmnaseri.utils.spring.data.domain.Parameter;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.query.Page;
import com.mmnaseri.utils.spring.data.query.PageParameterExtractor;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.query.Sort;
import com.mmnaseri.utils.spring.data.query.SortParameterExtractor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;

public class DefaultQueryDescriptor
implements QueryDescriptor {
    private static final Log log = LogFactory.getLog(InvocationMatcher.class);
    private final boolean distinct;
    private final String function;
    private final int limit;
    private final PageParameterExtractor pageExtractor;
    private final SortParameterExtractor sortExtractor;
    private final List<List<Parameter>> branches;
    private final RepositoryFactoryConfiguration configuration;
    private final RepositoryMetadata repositoryMetadata;

    public DefaultQueryDescriptor(boolean distinct, String function, int limit, PageParameterExtractor pageExtractor, SortParameterExtractor sortExtractor, List<List<Parameter>> branches, RepositoryFactoryConfiguration configuration, RepositoryMetadata repositoryMetadata) {
        this.distinct = distinct;
        this.function = function;
        this.limit = limit;
        this.pageExtractor = pageExtractor;
        this.sortExtractor = sortExtractor;
        this.branches = branches;
        this.configuration = configuration;
        this.repositoryMetadata = repositoryMetadata;
    }

    @Override
    public RepositoryFactoryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public RepositoryMetadata getRepositoryMetadata() {
        return this.repositoryMetadata;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Page getPage(Invocation invocation) {
        return this.pageExtractor == null ? null : (Page)this.pageExtractor.extract(invocation);
    }

    @Override
    public Sort getSort(Invocation invocation) {
        return this.sortExtractor == null ? null : (Sort)this.sortExtractor.extract(invocation);
    }

    @Override
    public List<List<Parameter>> getBranches() {
        return this.branches;
    }

    @Override
    public boolean matches(Object entity, Invocation invocation) {
        log.info((Object)("Matching " + entity + " against " + invocation));
        List<List<Parameter>> branches = this.getBranches();
        if (branches.isEmpty()) {
            return entity != null;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        for (List<Parameter> branch : branches) {
            boolean matches = true;
            for (Parameter parameter : branch) {
                boolean ignoreCase = parameter.getModifiers().contains((Object)Modifier.IGNORE_CASE);
                Object value = wrapper.getPropertyValue(parameter.getPath());
                if (ignoreCase && value instanceof String) {
                    value = ((String)value).toLowerCase();
                }
                Operator operator = parameter.getOperator();
                Object[] properties = new Object[operator.getOperands()];
                for (int i = 0; i < operator.getOperands(); ++i) {
                    properties[i] = invocation.getArguments()[parameter.getIndices()[i]];
                    if (!ignoreCase || properties[i] == null || !(properties[i] instanceof String)) continue;
                    properties[i] = ((String)properties[i]).toLowerCase();
                }
                if (operator.getMatcher().matches(parameter, value, properties)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return (this.getFunction() != null ? this.getFunction() + " " : "") + (this.isDistinct() ? "distinct " : "") + this.getBranches();
    }
}

