/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.DataStoreAware;
import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.KeyGeneratorAware;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataAware;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrudRepositorySupport
implements DataStoreAware,
RepositoryMetadataAware,
KeyGeneratorAware<Object> {
    private static final Log log = LogFactory.getLog(CrudRepositorySupport.class);
    private KeyGenerator<?> keyGenerator;
    private DataStore dataStore;
    private RepositoryMetadata repositoryMetadata;

    protected CrudRepositorySupport() {
    }

    public Object save(Object entity) {
        if (entity instanceof Iterable) {
            return this.save((Iterable)entity);
        }
        Object key = PropertyUtils.getPropertyValue(entity, this.repositoryMetadata.getIdentifierProperty());
        log.info((Object)("The entity that is to be saved has a key with value " + key));
        if (key == null && this.keyGenerator != null) {
            log.info((Object)"The key was null, but the generator was not, so we are going to get a key for the entity");
            key = this.keyGenerator.generate();
            log.debug((Object)("The generated key for the entity was " + key));
            PropertyUtils.setPropertyValue(entity, this.repositoryMetadata.getIdentifierProperty(), key);
        }
        if (key == null) {
            log.warn((Object)"Attempting to save an entity without a key. This might result in an error. To fix this, specify a key generator.");
        }
        this.dataStore.save(key, entity);
        return entity;
    }

    public Iterable<Object> save(Iterable entities) {
        LinkedList<Object> list = new LinkedList<Object>();
        log.info((Object)"Going to save a number of entities in the underlying data store");
        log.debug((Object)entities);
        for (Object entity : entities) {
            list.add(this.save(entity));
        }
        return list;
    }

    public Object insert(Object entity) {
        return this.save(entity);
    }

    protected KeyGenerator<?> getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public final void setKeyGenerator(KeyGenerator<?> keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    protected DataStore getDataStore() {
        return this.dataStore;
    }

    public final void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    protected RepositoryMetadata getRepositoryMetadata() {
        return this.repositoryMetadata;
    }

    @Override
    public final void setRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
    }
}

