/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.error.EntityMissingKeyException;
import com.mmnaseri.utils.spring.data.repository.CrudRepositorySupport;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCrudRepository
extends CrudRepositorySupport {
    private static final Log log = LogFactory.getLog(DefaultCrudRepository.class);

    public Iterable<Object> saveAll(Iterable entities) {
        return this.save(entities);
    }

    public Optional<Object> findById(Object key) {
        log.info((Object)("Attempting to load the entity with key " + key));
        return Optional.ofNullable(this.getDataStore().retrieve(key));
    }

    public boolean existsById(Object key) {
        return this.getDataStore().hasKey(key);
    }

    public Iterable findAllById(Iterable ids) {
        LinkedList<Object> entities = new LinkedList<Object>();
        log.info((Object)"Looking for multiple entities for a number of ids");
        log.debug((Object)ids);
        for (Object id : ids) {
            Optional<Object> found = this.findById(id);
            if (!found.isPresent()) continue;
            log.trace((Object)("Entity found for key " + id + ", adding the found entity to the list of returned entity"));
            entities.add(found.get());
        }
        return entities;
    }

    public Object deleteById(Object entity) {
        Object retrieved = this.getDataStore().retrieve(entity);
        log.info((Object)("Attempting to delete the entity with key " + entity));
        if (retrieved == null) {
            log.info((Object)("Object not found with key " + entity + ", try to find by identifier property"));
            try {
                entity = PropertyUtils.getPropertyValue(entity, this.getRepositoryMetadata().getIdentifierProperty());
                retrieved = this.getDataStore().retrieve(entity);
            }
            catch (IllegalStateException exception) {
                log.info((Object)"Serialized id doesn't have a identifier property");
            }
        }
        this.getDataStore().delete(entity);
        return retrieved;
    }

    public Object delete(Object id) {
        Object key = PropertyUtils.getPropertyValue(id, this.getRepositoryMetadata().getIdentifierProperty());
        if (key == null) {
            log.error((Object)"The entity that was supposed to be deleted, does not have a key");
            throw new EntityMissingKeyException(this.getRepositoryMetadata().getEntityType(), this.getRepositoryMetadata().getIdentifierProperty());
        }
        return this.deleteById(key);
    }

    public Iterable delete(Iterable entities) {
        log.info((Object)"Attempting to delete multiple entities via entity objects themselves");
        log.debug((Object)entities);
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object entity : entities) {
            Object deleted = this.deleteById(entity);
            if (deleted == null) continue;
            log.debug((Object)"The entity was deleted successfully and will be added to the list of deleted entities");
            list.add(deleted);
        }
        return list;
    }

    public Iterable deleteAll() {
        log.info((Object)"Attempting to delete all entities at once");
        LinkedList<Object> list = new LinkedList<Object>();
        Collection keys = this.getDataStore().keys();
        log.debug((Object)("There are " + keys.size() + " entities altogether in the data store that are going to be deleted"));
        for (Object key : keys) {
            Object deleted = this.deleteById(key);
            if (deleted == null) continue;
            log.debug((Object)"The entity was deleted successfully and will be added to the list of deleted entities");
            list.add(deleted);
        }
        Collection remainingKeys = this.getDataStore().keys();
        log.debug((Object)("There are " + remainingKeys.size() + " keys remaining in the data store after the delete operation"));
        return list;
    }
}

