/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.DataStoreAware;
import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.domain.Parameter;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadataAware;
import com.mmnaseri.utils.spring.data.domain.impl.ImmutableInvocation;
import com.mmnaseri.utils.spring.data.domain.impl.SelectDataStoreOperation;
import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.RepositoryConfigurationAware;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfigurationAware;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.repository.ExampleMatcherQueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.repository.PagingAndSortingUtils;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class DefaultQueryByExampleExecutor
implements DataStoreAware,
RepositoryConfigurationAware,
RepositoryMetadataAware,
RepositoryFactoryConfigurationAware {
    private final ExampleMatcherQueryDescriptionExtractor queryDescriptionExtractor = new ExampleMatcherQueryDescriptionExtractor();
    private DataStore<Object, Object> dataStore;
    private RepositoryConfiguration repositoryConfiguration;
    private RepositoryMetadata repositoryMetadata;
    private RepositoryFactoryConfiguration configuration;

    public Object findOne(Example example) {
        Collection<?> found = this.retrieveAll(example);
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() > 1) {
            throw new InvalidArgumentException("Expected to see exactly one item found, but found " + found.size() + ". You should use a better example.");
        }
        return found.iterator().next();
    }

    public Iterable findAll(Example example) {
        return this.retrieveAll(example);
    }

    public Iterable findAll(Example example, Sort sort) {
        return PagingAndSortingUtils.sort(this.retrieveAll(example), sort);
    }

    public Page findAll(Example example, Pageable pageable) {
        return PagingAndSortingUtils.page(this.retrieveAll(example), pageable);
    }

    public long count(Example example) {
        return this.retrieveAll(example).size();
    }

    public boolean exists(Example example) {
        return this.count(example) > 0L;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public void setRepositoryConfiguration(RepositoryConfiguration repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    @Override
    public void setRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
    }

    @Override
    public void setRepositoryFactoryConfiguration(RepositoryFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    private Collection<?> retrieveAll(Example example) {
        QueryDescriptor descriptor = this.queryDescriptionExtractor.extract(this.repositoryMetadata, this.configuration, example);
        Invocation invocation = this.createInvocation(descriptor, example);
        SelectDataStoreOperation select = new SelectDataStoreOperation(descriptor);
        return select.execute((DataStore)this.dataStore, this.repositoryConfiguration, invocation);
    }

    private Invocation createInvocation(QueryDescriptor descriptor, Example example) {
        ArrayList<Object> values = new ArrayList<Object>();
        List<List<Parameter>> branches = descriptor.getBranches();
        List<Parameter> parameters = branches.get(0);
        for (Parameter parameter : parameters) {
            String propertyPath = parameter.getPath();
            Object propertyValue = PropertyUtils.getPropertyValue(example.getProbe(), propertyPath);
            ExampleMatcher.PropertySpecifier specifier = example.getMatcher().getPropertySpecifiers().getForPath(propertyPath);
            values.add(specifier == null ? propertyValue : ((Optional)specifier.getPropertyValueTransformer().apply(Optional.ofNullable(propertyValue))).orElse(null));
        }
        return new ImmutableInvocation(null, values.toArray());
    }
}

