/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

class PropertyVisitor
implements ReflectionUtils.MethodCallback,
ReflectionUtils.FieldCallback {
    private final Class<? extends Annotation> annotationType;
    private String property;

    PropertyVisitor(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    public void doWith(@Nonnull Method method) throws IllegalArgumentException {
        if (this.property != null) {
            return;
        }
        if (AnnotationUtils.findAnnotation((Method)method, this.annotationType) != null) {
            this.property = PropertyUtils.getPropertyName(method);
        }
    }

    public void doWith(@Nonnull Field field) throws IllegalArgumentException {
        if (this.property != null) {
            return;
        }
        if (field.isAnnotationPresent(this.annotationType)) {
            this.property = field.getName();
        }
    }

    public String getProperty() {
        return this.property;
    }
}

