/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs.anchor;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;

public class AnchorBasicTutorialProgram
extends Program {
    private static final PublicKey PROGRAM_ID = new PublicKey("EkEwddr34fqnv2SJREPynyC335PE32PAfjY4LVW5bTJS");
    private static final String FUNCTION_NAMESPACE = "global::initialize";

    public static TransactionInstruction initialize(Account caller) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(caller.getPublicKey(), true, false));
        byte[] transactionData = AnchorBasicTutorialProgram.encodeInitializeData();
        return AnchorBasicTutorialProgram.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    private static byte[] encodeInitializeData() {
        MessageDigest digest = null;
        byte[] encodedHash = null;
        int sigHashStart = 0;
        int sigHashEnd = 8;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            encodedHash = Arrays.copyOfRange(digest.digest(FUNCTION_NAMESPACE.getBytes(StandardCharsets.UTF_8)), sigHashStart, sigHashEnd);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return encodedHash;
    }
}

