/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import org.robovm.apple.addressbook.ABPersonInstantMessageService;
import org.robovm.apple.addressbook.ABPropertyLabel;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="AddressBook")
public class ABPersonInstantMessageAccount
extends CocoaUtility {
    private CFDictionary data;
    private CFString label;

    public ABPersonInstantMessageAccount(String username, ABPersonInstantMessageService service, String label) {
        this.data = CFMutableDictionary.create();
        this.setUsername(username);
        this.setService(service);
        this.label = new CFString(label);
    }

    public ABPersonInstantMessageAccount(String username, ABPersonInstantMessageService service, ABPropertyLabel label) {
        this.data = CFMutableDictionary.create();
        this.setUsername(username);
        this.setService(service);
        this.label = label.value();
    }

    protected ABPersonInstantMessageAccount(CFDictionary data, CFString label) {
        this.data = data;
        this.label = label;
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public String getLabel() {
        return this.label.toString();
    }

    public CFString getLabel0() {
        return this.label;
    }

    public String getUsername() {
        if (this.data.containsKey(ABPersonInstantMessageAccount.UsernameKey())) {
            CFString val = this.data.get(ABPersonInstantMessageAccount.UsernameKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public ABPersonInstantMessageAccount setUsername(String username) {
        this.data.put(ABPersonInstantMessageAccount.UsernameKey(), new CFString(username));
        return this;
    }

    public ABPersonInstantMessageService getService() {
        if (this.data.containsKey(ABPersonInstantMessageAccount.ServiceKey())) {
            CFString val = this.data.get(ABPersonInstantMessageAccount.ServiceKey(), CFString.class);
            return ABPersonInstantMessageService.valueOf(val);
        }
        return null;
    }

    public ABPersonInstantMessageAccount setService(ABPersonInstantMessageService service) {
        this.data.put(ABPersonInstantMessageAccount.ServiceKey(), (NativeObject)service.value());
        return this;
    }

    @Deprecated
    @GlobalValue(symbol="kABPersonInstantMessageServiceKey", optional=true)
    protected static native CFString ServiceKey();

    @Deprecated
    @GlobalValue(symbol="kABPersonInstantMessageUsernameKey", optional=true)
    protected static native CFString UsernameKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(ABPersonInstantMessageAccount.class);
    }
}

