/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AudioFileStreamMutablePropertyFlags;
import org.robovm.apple.audiotoolbox.AudioFileStreamMutableSeekFlags;
import org.robovm.apple.audiotoolbox.AudioFileStreamParseFlags;
import org.robovm.apple.audiotoolbox.AudioFileStreamProperty;
import org.robovm.apple.audiotoolbox.AudioFileType;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.coreaudio.AudioStreamPacketDescription;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.objc.LongMap;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioFileStream
extends NativeObject {
    private static AtomicLong callbackId = new AtomicLong();
    private static LongMap<ParseListener> parseListeners = new LongMap();
    private static final Method cbParseProperty;
    private static final Method cbParsePackets;
    private long cid;

    protected AudioFileStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbParseProperty(@Pointer long clientData, AudioFileStream audioFileStream, AudioFileStreamProperty property, AudioFileStreamMutablePropertyFlags flags) {
        LongMap<ParseListener> longMap = parseListeners;
        synchronized (longMap) {
            ((ParseListener)parseListeners.get(clientData)).onPropertyParsed(audioFileStream, property, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbParsePackets(@Pointer long clientData, int numberBytes, int numberPackets, @Pointer long inputData, AudioStreamPacketDescription packetDescriptions) {
        LongMap<ParseListener> longMap = parseListeners;
        synchronized (longMap) {
            ((ParseListener)parseListeners.get(clientData)).onPacketsParsed(numberBytes, inputData, (AudioStreamPacketDescription[])packetDescriptions.toArray(numberPackets));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileStream open(ParseListener parseListener, AudioFileType fileTypeHint) throws OSStatusException {
        AudioFileStreamPtr ptr;
        if (parseListener == null) {
            throw new NullPointerException("parseListener");
        }
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioFileStream.open0(cid, new FunctionPtr(cbParseProperty), new FunctionPtr(cbParsePackets), fileTypeHint, ptr = new AudioFileStreamPtr());
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<ParseListener> longMap = parseListeners;
            synchronized (longMap) {
                parseListeners.put(cid, (Object)parseListener);
            }
        }
        AudioFileStream result = (AudioFileStream)ptr.get();
        result.cid = cid;
        return result;
    }

    public void parseBytes(byte[] bytes, AudioFileStreamParseFlags flags) throws OSStatusException {
        OSStatus status = this.parseBytes0(bytes.length, VM.getArrayValuesAddress((Object)bytes), flags);
        OSStatusException.throwIfNecessary(status);
    }

    public long seek(long packetOffset, AudioFileStreamMutableSeekFlags flags) throws OSStatusException {
        LongPtr ptr = new LongPtr();
        OSStatus status = this.seek0(packetOffset, ptr, flags);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public int getPropertySize(AudioFileStreamProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertyInfo0(id, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isPropertyWritable(AudioFileStreamProperty id) throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getPropertyInfo0(id, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getProperty(AudioFileStreamProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(id, dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(AudioFileStreamProperty id, T data) throws OSStatusException {
        OSStatus status = this.setProperty0(id, data == null ? 0 : Struct.sizeOf(data), data == null ? null : (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(AudioFileStreamProperty id) throws OSStatusException {
        IntPtr ptr = this.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    public long getPropertyAsLong(AudioFileStreamProperty id) throws OSStatusException {
        LongPtr ptr = this.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    public float getPropertyAsFloat(AudioFileStreamProperty id) throws OSStatusException {
        FloatPtr ptr = this.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    public double getPropertyAsDouble(AudioFileStreamProperty id) throws OSStatusException {
        DoublePtr ptr = this.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    public void setProperty(AudioFileStreamProperty id, int value) throws OSStatusException {
        this.setProperty(id, new IntPtr(value));
    }

    public void setProperty(AudioFileStreamProperty id, long value) throws OSStatusException {
        this.setProperty(id, new LongPtr(value));
    }

    public void setProperty(AudioFileStreamProperty id, float value) throws OSStatusException {
        this.setProperty(id, new FloatPtr(value));
    }

    public void setProperty(AudioFileStreamProperty id, double value) throws OSStatusException {
        this.setProperty(id, new DoublePtr(value));
    }

    public AudioStreamBasicDescription getDataFormat() throws OSStatusException {
        return this.getProperty(AudioFileStreamProperty.DataFormat, AudioStreamBasicDescription.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OSStatusException {
        OSStatus status = this.close0();
        OSStatusException.throwIfNecessary(status);
        LongMap<ParseListener> longMap = parseListeners;
        synchronized (longMap) {
            parseListeners.remove(this.cid);
        }
    }

    @Bridge(symbol="AudioFileStreamOpen", optional=true)
    protected static native OSStatus open0(@Pointer long var0, FunctionPtr var2, FunctionPtr var3, AudioFileType var4, AudioFileStreamPtr var5);

    @Bridge(symbol="AudioFileStreamParseBytes", optional=true)
    protected native OSStatus parseBytes0(int var1, @Pointer long var2, AudioFileStreamParseFlags var4);

    @Bridge(symbol="AudioFileStreamSeek", optional=true)
    protected native OSStatus seek0(long var1, LongPtr var3, AudioFileStreamMutableSeekFlags var4);

    @Bridge(symbol="AudioFileStreamGetPropertyInfo", optional=true)
    protected native OSStatus getPropertyInfo0(AudioFileStreamProperty var1, IntPtr var2, BooleanPtr var3);

    @Bridge(symbol="AudioFileStreamGetProperty", optional=true)
    protected native OSStatus getProperty0(AudioFileStreamProperty var1, IntPtr var2, VoidPtr var3);

    @Bridge(symbol="AudioFileStreamSetProperty", optional=true)
    protected native OSStatus setProperty0(AudioFileStreamProperty var1, int var2, VoidPtr var3);

    @Bridge(symbol="AudioFileStreamClose", optional=true)
    protected native OSStatus close0();

    static {
        try {
            cbParseProperty = AudioFileStream.class.getDeclaredMethod("cbParseProperty", Long.TYPE, AudioFileStream.class, AudioFileStreamProperty.class, AudioFileStreamMutablePropertyFlags.class);
            cbParsePackets = AudioFileStream.class.getDeclaredMethod("cbParsePackets", Long.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, AudioStreamPacketDescription.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioFileStream.class);
    }

    public static interface ParseListener {
        public void onPropertyParsed(AudioFileStream var1, AudioFileStreamProperty var2, AudioFileStreamMutablePropertyFlags var3);

        public void onPacketsParsed(int var1, long var2, AudioStreamPacketDescription[] var4);
    }

    public static class AudioFileStreamPtr
    extends Ptr<AudioFileStream, AudioFileStreamPtr> {
    }
}

