/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public enum AudioFormatProperty implements ValuedEnum
{
    FormatInfo(1718449257L),
    FormatName(1718509933L),
    EncodeFormatIDs(1633906534L),
    DecodeFormatIDs(1633904998L),
    FormatList(1718383476L),
    ASBDFromESDS(1702064996L),
    ChannelLayoutFromESDS(1702060908L),
    OutputFormatList(1868983411L),
    FirstPlayableFormatFromList(1718642284L),
    FormatIsVBR(0x66766272L),
    FormatIsExternallyFramed(1717925990L),
    FormatEmploysDependentPackets(1717855600L),
    FormatIsEncrypted(1668446576L),
    Encoders(1635149166L),
    Decoders(1635148901L),
    AvailableEncodeBitRates(1634034290L),
    AvailableEncodeSampleRates(1634038642L),
    AvailableEncodeChannelLayoutTags(1634034540L),
    AvailableEncodeNumberChannels(1635151459L),
    ASBDFromMPEGPacket(1633971568L),
    BitmapForLayoutTag(1651340391L),
    MatrixMixMap(1835884912L),
    ChannelMap(1667788144L),
    NumberOfChannelsForLayout(1852008557L),
    AreChannelLayoutsEquivalent(1667786097L),
    ChannelLayoutHash(1667786849L),
    ValidateChannelLayout(1986093932L),
    ChannelLayoutForTag(1668116588L),
    TagForChannelLayout(1668116596L),
    ChannelLayoutName(1819242093L),
    ChannelLayoutSimpleName(1819504237L),
    ChannelLayoutForBitmap(1668116578L),
    ChannelName(1668178285L),
    ChannelShortName(1668509293L),
    TagsForNumberOfChannels(1952540515L),
    PanningMatrix(1885433453L),
    BalanceFade(1650551910L),
    ID3TagSize(1768174451L),
    ID3TagToDictionary(1768174436L);

    private final long n;

    public int getPropertySize(Struct<?> specifier) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = AudioFormatProperty.getPropertyInfo0(this, specifier == null ? 0 : Struct.sizeOf(specifier), specifier == null ? null : (VoidPtr)specifier.as(VoidPtr.class), ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getProperty(Struct<?> specifier, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = AudioFormatProperty.getProperty0(this, specifier == null ? 0 : Struct.sizeOf(specifier), specifier == null ? null : (VoidPtr)specifier.as(VoidPtr.class), dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    @Bridge(symbol="AudioFormatGetPropertyInfo", optional=true)
    protected static native OSStatus getPropertyInfo0(AudioFormatProperty var0, int var1, VoidPtr var2, IntPtr var3);

    @Bridge(symbol="AudioFormatGetProperty", optional=true)
    protected static native OSStatus getProperty0(AudioFormatProperty var0, int var1, VoidPtr var2, IntPtr var3, VoidPtr var4);

    private AudioFormatProperty(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static AudioFormatProperty valueOf(long n) {
        for (AudioFormatProperty v : AudioFormatProperty.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + AudioFormatProperty.class.getName());
    }

    static {
        Bro.bind(AudioFormatProperty.class);
    }
}

